/*------------------------------------------------------------------------------*
 * File Name: FilePublish.h														*
 * Creation: Jasmine 08/15/07													*
 * Purpose: 																	*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Hong 08/15/07 v8.0682 PUBLISH_FILTER_WITH_DRAG_AND_GROP_SETTING				*
 *	Folger 08/20/07 ADD_BOOLEAN_CONTROL_COPY_DIRECTION							*
 *	Folger 08/21/07 CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR						*
 *	Folger 08/22/07 UNFIY_FUNC_GET_FILES_INTERFACE								*
 *	Hong 08/22/07 v8.0687 REMOVE_FILE_NOT_EXIST_IN_ACCORDING_FOLDER				*
 *	Hong 08/22/07 IMPROVE_CODE													*
 *	Folger 08/23/07 IMPLEMENT_TEMPLATE_PUBLISH									*
 *	Folger 08/24/07 GET_COL_HEADING_BY_FILE_PATH								*
 *	Folger 08/27/07 ADD_FILETYPES_OGS_THEME_XF									*
 *	Folger 08/27/07 CREATE_FILE_CATEGORY_PUBLISH_TO_SUPPORT_GRID_WITH_CATEGORY	*
 *	Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80						*
 *	Folger 08/29/07 SAVE_PARTITIAL_GROUP_PATH_FOR_PUBLISH						*
 *	Folger 08/30/07 FIX_BUGS_WHEN_MOVE_FILES_FROM_GROUP_TO_USER					*
 *	Folger 08/30/07 MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80	*
 *	Folger 08/30/07 USE_NEW_OKUTIL_ADD_TEMPLATE									*
 *	Folger 08/31/07 USE_OKUTIL_FUNCTION_GET_ORIGIN75_USER_PATH					*
 *	CPY 9/1/2007 CLEAN_UP_CODE_RELATED_TO_GETTING_75_FDF_FILES					*
 *	Folger 09/03/07 SUPPORT_GET_ORIGIN75_PATH_IN_FILE_PUBLISH					*
 *	Folger 09/03/07 SUPPORT_MORE_FILE_TYPES										*
 *	Folger 09/04/07 GET_NLFIT_FILE_NAME_INSTEAD_OF_FUNCTION_NAME				*
 *	Folger 09/05/07 CLEAN_UP_FDF_MODIFICATION_CODES								*
 *	Folger 09/08/07 SUPPORT_PATCH_FILE											*
 *	Folger 09/11/07 MAKE_PATH_BEFORE_COPY										*
 *	Folger 09/11/07 FIX_BUGS_IN_FDF_FILE_COMPARE								*
 *	Folger 09/14/07 REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR			*
 *	CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH			*
 *	Folger 09/24/07 CLEAN_UP_TEMPLATE_PUBLISH_FOR_CORRECT_LOGIC					*
 *	Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION					*
 *	Folger 09/27/07 RESET_ATTRIBUTE_WHEN_COPY_FILE								*
 *	Folger 09/27/07 DELETE_FILE_REGARDLESS_OF_READ_ONLY							*
 *	Folger 09/28/07 SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION					*
 *	Folger 09/29/07 NEW_DISIGN_FOR_SAVING_TEMPLATE_XML							*
 *	EJP 2007-10-02 v8.0714 QA70-10469 MORE_WORK_FOR_OPX_AND_GROUP_FOLDER		*
 *	Folger 10/08/07 QA70-10469 FIX_OPX_FILES_CANNOT_BE_SEEN_IN_GORUPMGR_GROUP_SIDE*
 *	Folger 11/05/07 CORRECT_THEME_TYPE_COMPARE									*
 *	Folger 11/27/07 EXCLUDE_DEFAULT_FUNCTION_IN_GRID							*
 *	Folger 12/05/07 REMOVE_UNKNOWN_TEMPLATE_SAVED_IN_USER_TEMPLATE_XML			*
 *	Folger 01/14/08 NEED_TO_MANIPULATE_DLL_FILE_WITH_EXTERNAL_DLL_FDF			*
 *	Folger 01/31/08 QA80-10933 FIX_BUG_OF_DLL_FILE_NAME_CONVENTION				*
 *	Folger 03/20/08 QA80-11192 SUPPORT_DEFAULT_SETTINGS_FILE					*
 *	Folger 04/03/08 FIX_DEFAULT_XML_PUBLISH_IN_ALL_FILES						*
 *	Folger 09/18/08 QA80-12217 SUPPORT_PUBLISHING_DATABASE_FILES				*
 *	Folger 09/19/08 FIX_TEMPLATE_TRANSFER_FAIL_WHEN_TEMPLATE_XML_IN_UFF_IS_NOT_EXIST
 *	Folger 09/18/08 QA80-12217 SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER	*
 *	Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL		*
 *	Kenny 11/11/2009 QA81-14624 SUPPORT_DRAG_AND_DROP_MULTIPLE_ORIGIN_FILES		*
 *	Folger 07/12/10 ORG-532 TRANSFER_USER_FILES_FAILED_TO_SHOW_81_FILES			*
 *	Kyle 08/02/2010 ORG-692-P1 TRANSFER_USER_FILES_HANDLE_DOCX_FILE				*
 *	Kyle 08/04/2010 ORG-710-P1 SHOW_ONLY_GRAPH_OR_WORKSHEET_THEME_IF_PATH_SPECIFIED
 *------------------------------------------------------------------------------*/

#ifndef _FILE_PUBLISH_H_
#define	_FILE_PUBLISH_H_

///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
// comment out all the old code and rewrite it with new design
//
#ifndef _OLD_GROUP_FOLDER_MANAGER_AND_TRANSFER_USER_FILES_

#define SUPPORT_PACKAGE_FILES

//////////////////////////////////////////////////////////////////////////////// begin of new code ///////////////////////////////////////////////////////////////




#define STR_ORIGIN_REGISTRY_KEY 			"Software\\OriginLab\\"
///------ Folger 07/12/10 ORG-532 TRANSFER_USER_FILES_FAILED_TO_SHOW_81_FILES
//#define CURRENT_VERSION						8.1
///------ End TRANSFER_USER_FILES_FAILED_TO_SHOW_81_FILES

enum
{
	FB_COL_FILE,
	FB_COL_CATEGORY,
	FB_COL_FILETYPE,
	FB_COL_FILESIZE,
	FB_COL_FILEDATE,
	FB_COL_NUMS,
};

#define STR_OMC_FILE_EXT				"." MENU_CUSTOMIZATION_FILE_EXT


#include "NumFunctionOrganizer.h"

/// Kenny 11/11/2009 QA81-14624 SUPPORT_DRAG_AND_DROP_MULTIPLE_ORIGIN_FILES
/*
static bool _update_function_to_nlsf(LPCSTR lpcszCategoryName, LPCSTR lpcszNewName, LPCSTR lpcszOldName, LPCSTR lpcszFileName, LPCSTR lpcszIniPath)
{
	string strINIFileUser(lpcszIniPath), strOldName(lpcszOldName), strNewName(lpcszNewName);
	string strFileName = GetFileName(lpcszFileName, true);

	strINIFileUser.TrimRight("\\");
	strINIFileUser += "\\" + "NLSF.ini";
	INIFile iniNLSF(strINIFileUser);

	bool bRet = true;
	if(!strOldName.IsEmpty())
		bRet &= update_ini_line(iniNLSF, lpcszCategoryName, strOldName, NULL);
	if(bRet && !strNewName.IsEmpty())
		bRet &= update_ini_line(iniNLSF, lpcszCategoryName, strNewName, strFileName);
	return bRet;
}
static bool _update_category_to_nlsf(LPCSTR lpcszNewName, LPCSTR lpcszOldName, LPCSTR lpcszIniPath)
{
	string strINIFileUser(lpcszIniPath), strOldName(lpcszOldName), strNewName(lpcszNewName);
	
	strINIFileUser.TrimRight("\\");
	strINIFileUser += "\\" + "NLSF.ini";
	INIFile iniNLSF(strINIFileUser);

	vector<string> vsKeys, vsValues, vsCKeys, vsCValues;
	int nPos;
	bool bRet=true;
	if(!strOldName.IsEmpty() && !strNewName.IsEmpty())
	{
		bRet &= _nlf_get_section_keys_and_values(strOldName, vsKeys, vsValues, NULL, lpcszIniPath);
		bRet &= _nlf_get_section_keys_and_values(STR_NODE_CATEGORY, vsCKeys, vsCValues, NULL, lpcszIniPath);
	}

	if(!strOldName.IsEmpty())
	{
		bRet &= update_ini_line(iniNLSF, STR_NODE_CATEGORY, strOldName, NULL);	//delete old category in category list
		if(!strNewName.IsEmpty())
			bRet &= update_ini_line(iniNLSF, STR_NODE_CATEGORY, NULL, NULL);//delete the whole old category list 
		if(bRet)
			bRet &= update_ini_line(iniNLSF, strOldName, NULL, NULL);	//delete old category and the functions
		nPos = vsCKeys.Find(strOldName);
	}

	if(!strNewName.IsEmpty())
	{
		for(int nIndex =0 ;nIndex <  vsKeys.GetSize(); nIndex++)
			bRet &= update_ini_line(iniNLSF, strNewName, vsKeys[nIndex], vsValues[nIndex]);
		if(strOldName.IsEmpty())
			update_ini_line(iniNLSF, STR_NODE_CATEGORY, strNewName, STR_FDF_FILE_FOLDER);
		else
		{
			if(nPos > -1 && nPos < vsCKeys.GetSize())
				vsCKeys[nPos] = strNewName;
			for(nIndex =0 ;nIndex <  vsCKeys.GetSize(); nIndex++)
				bRet &= update_ini_line(iniNLSF, STR_NODE_CATEGORY, vsCKeys[nIndex], vsCValues[nIndex]);
		}
	}
	return bRet;
}

static bool _nlf_get_section_keys_and_values(LPCSTR lpcszSection, vector<string> &saKeys, vector<string> &saValues, int* pnDefaultSel, LPCSTR lpcszPath)
{
	int	nDefaultSel = 0;
	saKeys.RemoveAll();

	string strNLSFIniFilePath(lpcszPath);
	strNLSFIniFilePath.TrimRight("\\");
	strNLSFIniFilePath += "\\" + "NLSF.ini";
	INIFile iniNLSF(strNLSFIniFilePath);// when full path given, no need to worry about 2nd arg

	int nKeysCount = iniNLSF.GetKeyNames(saKeys, lpcszSection);
	
	if(saValues != NULL)
	{
		saValues.RemoveAll();
		for(int nIndex = 0 ; nIndex < nKeysCount ; nIndex++)
			saValues.Add( iniNLSF.ReadString(lpcszSection, saKeys[nIndex]));
	}
	
	if(pnDefaultSel != NULL )
	{
		int nDefaIndex = saKeys.Find("Default Function" , 0 , true);
		if(nDefaIndex < 0 )
		{
			nDefaultSel = 0;
		}
		else
		{
			string strDefFunction;

			strDefFunction = saValues[nDefaIndex];
			saKeys.RemoveAt( nDefaIndex , 1);
			saValues.RemoveAt( nDefaIndex , 1);
			nDefaultSel = saKeys.Find( strDefFunction , 0 , true );
		}
		*pnDefaultSel = nDefaultSel;
	}
	return true;
}
*/
#define	_update_function_to_nlsf(lpcszCategoryName, lpcszNewName, lpcszOldName, lpcszFileName, lpcszIniPath)	\
			nlsf_update_function(lpcszCategoryName, lpcszNewName, lpcszOldName, lpcszFileName, 0, lpcszIniPath)


#define	_update_category_to_nlsf(lpcszNewName, lpcszOldName, lpcszIniPath)	\
			nlsf_update_category(lpcszNewName, lpcszOldName, 0, lpcszIniPath)

#define	_nlf_get_section_keys_and_values(lpcszSection, saKeys, saValues, pnDefaultSel, lpcszPath)	\
			nlf_get_section_keys_and_values(lpcszSection, saKeys, saValues, pnDefaultSel, 0, lpcszPath)
/// End QA81-14624 SUPPORT_DRAG_AND_DROP_MULTIPLE_ORIGIN_FILES

struct FDFPaths
{
	string strFilePath;
	string strIniPath;
	string strSysPath;
};


bool get_origin_user_path(string& strFilePath, LPCSTR lpcszRegVerKey, bool bUserPath)
{
	strFilePath.Empty();
	Registry reg(HKEY_CURRENT_USER);
	string	strMainKey = STR_ORIGIN_REGISTRY_KEY,
			strPath = bUserPath ? "Path" : "Executable Path";
	strMainKey += lpcszRegVerKey;
	vector<string> vsLanguages;
	if(reg.EnumKey(vsLanguages, strMainKey)==0)
		return false;

	for(int ii = 0; ii < vsLanguages.GetSize(); ii++)
	{
		if(reg.GetValue(strMainKey + "\\" + vsLanguages[ii], strPath, strFilePath) && strFilePath.IsPath())
			return true;
	}
	return false;
}

class GroupFunctionOrganizer : public NumFunctionOrganizer
{
public:
	int	GetCategoryList(vector<string> &vsCategorys, LPCSTR lpcszIniPath)
	{
		vsCategorys.SetSize(0);
		_nlf_get_section_keys_and_values(STR_NODE_CATEGORY, vsCategorys, NULL, NULL, lpcszIniPath);
		
		return vsCategorys.GetSize();
	}
	
	int	GetFunctionList(vector<string> &vsFunctions, vector<string> &vsFunctionFullFileNames, LPCSTR lpcstrCategoryName, const FDFPaths& fdfPaths)
	{
		vsFunctions.SetSize(0);
		vsFunctionFullFileNames.SetSize(0);

		string strPath = fdfPaths.strFilePath;
		strPath.TrimRight("\\");
		strPath += "\\";

		int nDefaultFunc = 0;
		_nlf_get_section_keys_and_values(lpcstrCategoryName, vsFunctions, vsFunctionFullFileNames, &nDefaultFunc, fdfPaths.strIniPath);

		string strFunctionFullPath;
		for (int ii = vsFunctionFullFileNames.GetSize() - 1; ii >= 0; ii--)
		{
			strFunctionFullPath = strPath + vsFunctionFullFileNames[ii] + ".fdf";
			 if ( !strFunctionFullPath.IsFile() )
			 {
			 	vsFunctionFullFileNames.RemoveAt(ii);
			 	vsFunctions.RemoveAt(ii);
			 }
		}
		return vsFunctions.GetSize();
	}
	
	int GetFilesList(vector<string> &vsFunctions, vector<string> &vsFunctionFullFileNames, const FDFPaths& fdfPaths)
	{
		vector<string> vsCategoties;
		GetCategoryList(vsCategoties, fdfPaths.strIniPath);
		
		for (int ii = 0; ii < vsCategoties.GetSize(); ii++)
		{			
			vector<string> vsFuncTemp, vsFuncFNamesTemp;
			if ( GetFunctionList(vsFuncTemp, vsFuncFNamesTemp, vsCategoties[ii], fdfPaths) > 0 )
			{
				vsFunctions.Append(vsFuncTemp);
				vsFunctionFullFileNames.Append(vsFuncFNamesTemp);
			}			
		}		
		return vsFunctions.GetSize();
	}
	
	bool AddFile(LPCSTR lpcszName, const FDFPaths& fdfSrcPaths, const FDFPaths& fdfDestPaths)
	{
		string strSrcFilePath = fdfSrcPaths.strFilePath;
		string strDestFilePath = fdfDestPaths.strFilePath;
		if(!getFunctionFileSourceDestination(lpcszName, strSrcFilePath, strDestFilePath))
			return false;
		
		string strDLLFile;		//------ Folger 01/14/08 NEED_TO_MANIPULATE_DLL_FILE_WITH_EXTERNAL_DLL_FDF
		
		CheckMakePath(GetFilePath(strDestFilePath));
		if (copyfile(strSrcFilePath, strDestFilePath, 0))
			return false;
		if ( checkGetDLLFileName(strSrcFilePath, strDLLFile, fdfSrcPaths.strSysPath) )
			copyfile(strDLLFile, GetFilePath(strDestFilePath) + GetFileName(strDLLFile));
		
		vector<string> vsCategories;
		string strFunction;
		if(fdfSrcPaths.strIniPath.IsEmpty())		// specified fdf, try to get the ini file or get a default category and function name
			checkGetCategory(strSrcFilePath, strFunction, vsCategories);
		else
			GetCategories(lpcszName, strFunction, vsCategories, fdfSrcPaths);
		
		for (int ii = 0; ii < vsCategories.GetSize(); ii++)
		{
			_update_category_to_nlsf(vsCategories[ii], NULL, fdfDestPaths.strIniPath);
			_update_function_to_nlsf(vsCategories[ii], strFunction, NULL, lpcszName, fdfDestPaths.strIniPath);
		}
		return true;
	}

	bool RemoveFile(LPCSTR lpcszName, const FDFPaths& fdfPaths, bool bBackup)
	{
		vector<string> vsCategories;		
		string strFunction;
		GetCategories(lpcszName, strFunction, vsCategories, fdfPaths);
		
		for (int ii = 0; ii < vsCategories.GetSize(); ii++)
		{
			_update_function_to_nlsf(vsCategories[ii], NULL, strFunction, lpcszName, fdfPaths.strIniPath);
		}

		string strPath = fdfPaths.strFilePath;
		strPath.TrimRight("\\");
		strPath += "\\";
		string strFilePath = strPath + lpcszName + ".fdf";
		string strDLLFile;
		checkGetDLLFileName(lpcszName, strDLLFile, fdfPaths.strSysPath, false);
				
		if(bBackup)
		{
			string	strDeletePath = strPath + STR_FDF_DELETE_FILE_FOLDER + "\\";
			if( CheckMakePath( strDeletePath ) )
			{
				copyfile(strFilePath, strDeletePath + lpcszName + ".fdf", 0);
				copyfile(strDLLFile, strDeletePath + GetFileName(strDLLFile));
			}
		}
		if (!okutil_delete_file(strFilePath, true))
			return false;
		
		okutil_delete_file(strDLLFile, true);
		
		return true;
	}

	int GetCategories(LPCSTR lpcszFileName, string &strFunction, vector<string>& vsCategories, const FDFPaths& fdfPaths)
	{
		vsCategories.RemoveAll();
		GetCategoryList(vsCategories, fdfPaths.strIniPath);
		for (int ii = vsCategories.GetSize() - 1; ii >= 0; ii--)
		{
			vector<string> vsFunctions, vsFunctionFullFileNames;
			GetFunctionList(vsFunctions, vsFunctionFullFileNames, vsCategories[ii], fdfPaths);
			int nIndex = vsFunctionFullFileNames.Find(lpcszFileName);
			if (nIndex < 0)
				vsCategories.RemoveAt(ii);
			else
			{
				if (strFunction.IsEmpty())
					strFunction = vsFunctions[nIndex];
			}
		}
		
		return vsCategories.GetSize();
	}
	
private:
	bool getFunctionFileSourceDestination(LPCSTR lpcszName, string& strSrcFilePath, string& strDestFilePath)
	{ 
		strSrcFilePath.TrimRight("\\");
		strSrcFilePath = strSrcFilePath + "\\" + lpcszName + ".fdf";
		strDestFilePath.TrimRight("\\");
		strDestFilePath = strDestFilePath + "\\" + lpcszName + ".fdf";
		return true;
	}
	
	bool	checkGetDLLFileName(LPCSTR lpcszName, string &strDLLFile, LPCSTR lpcszSysPath, bool bCopy = true)
	{
		INIFile fdf(lpcszName, false);
		string strFuncType = fdf.ReadString(STR_FUNC_GENERAL_INFO, STR_FUNC_TYPE);
		if ( strFuncType.CompareNoCase(STR_FUNCTION_TYPE_EXTERN_DLL) != 0 )
			return false;
		
		string strFile = fdf.ReadString(STR_FUNC_GENERAL_INFO, STR_FUNCTION_SOURCE);

		vector<string> vsTmp;
		strFile.GetTokens(vsTmp, '.');
		strFile = vsTmp[0];
		//------
		LPSTR lpszDLLFile = strFile.GetBuffer(MAXLINE);
		check_add_file_ext(lpszDLLFile, STR_FUNCTION_DLL_SOURCE);
		strFile.ReleaseBuffer();
		strDLLFile = GetFilePath(lpcszName) + strFile;
		if ( !strDLLFile.IsFile() )
		{
			if ( !bCopy )
				return false;
			strDLLFile = lpcszSysPath;
			strDLLFile.TrimRight("\\");
			strDLLFile += "\\";

			strDLLFile += strFile;
			if ( !strDLLFile.IsFile() )
				return false;
		}
		
		return true;
	}

	int checkGetCategory(LPCSTR lpcszFDF, string& strFunction, vector<string>& vsCategories)
	{
		string strFDF = lpcszFDF;
		INIFile fdf(lpcszFDF);
		strFunction = fdf.ReadString(STR_FUNC_GENERAL_INFO, STR_FUNC_NAME);
		strFunction.TrimLeft();
		strFunction = strFunction.GetToken(0);
		strFunction.TrimRight();
		if(strFunction.IsEmpty())
			return 0;
		string strFileName = GetFileName(lpcszFDF, true);

		vsCategories.SetSize(0);
		string strIniPath = GetFilePath(lpcszFDF);
		strIniPath.TrimRight("\\");
		int nPos = strIniPath.ReverseFind('\\');
		if(nPos > 0)
		{
			strIniPath = strIniPath.Left(nPos);				// the parent path
			GetCategoryList(vsCategories, strIniPath);
		}

		for (int ii = vsCategories.GetSize() - 1; ii >= 0; ii--)
		{
			vector<string> vsFunctions, vsFunctionFullFileNames;
			int nDefaultFunc = 0;
			_nlf_get_section_keys_and_values(vsCategories[ii], vsFunctions, vsFunctionFullFileNames, &nDefaultFunc, strIniPath);

			int nFuncIndex = vsFunctions.Find(strFunction);
			int nFileIndex = vsFunctionFullFileNames.Find(strFileName);
			if (nFuncIndex < 0 || nFileIndex < 0 || nFuncIndex != nFileIndex)
				vsCategories.RemoveAt(ii);
		}
		if(vsCategories.GetSize() == 0)				// default category
		{
			vsCategories.Add("Origin Basic Functions");
		}
		
		return vsCategories.GetSize();
	}
};

class FilePublishBase
{
public:
	FilePublishBase()
	{
		GetSourceDestFilePath();
	}

	virtual int	GetAvailableCates(vector<string>& vsCategories)
	{
		vsCategories.SetSize(0);
		return 0;
	}
	
	virtual void SetDestCategory(LPCSTR lpcszCategory)
	{
		ASSERT(false);
	}
	
	virtual string GetDestCategory(LPCSTR lpcszFile = NULL)
	{
		return "";
	}
	
	virtual bool IsSrcPathSpecified()
	{
		return false;
	}

	virtual int GetFiles(bool bSource, vector<string>& vsFiles){ return -1;}
	

	virtual int PublishFiles(vector<string> &vsFileNames, bool bForward = true)
	{
		int nSize = vsFileNames.GetSize();
		vector<string> vsFileFullNames(nSize);

		string strPath = bForward ? m_strSrcPath : m_strDestPath;
		for (int ii=0; ii<nSize; ii++)
		{
			vsFileFullNames[ii] = strPath + vsFileNames[ii];
		}
		int nRet = CopyFiles(vsFileFullNames, bForward);

		if (nRet != nSize)
		{
			for (ii=nSize-1; ii>=0; ii--)
			{
				if (vsFileFullNames[ii].IsEmpty())
					vsFileNames.RemoveAt(ii);
			}
		}
		return nRet;
	}
	
	virtual int RemoveFiles(vector<string> &vsFileNames, bool bSource)
	{
		int nSize = vsFileNames.GetSize();
		string strPath = bSource ? m_strSrcPath : m_strDestPath;
		for (int ii=nSize-1; ii>=0; ii--)
		{
			if (!okutil_delete_file(strPath + vsFileNames[ii], true))
				vsFileNames.RemoveAt(ii);
		}
		return vsFileNames.GetSize();
	}
	
	virtual int GetColNames(vector<string> &vsColNames, bool bSource)
	{
		vsColNames.SetSize(FB_COL_NUMS);

		if(bSource)
			vsColNames[FB_COL_FILE] = _L("User Files");
		else
			vsColNames[FB_COL_FILE] = _L("Group Files");
		vsColNames[FB_COL_CATEGORY] = _L("Category");
		vsColNames[FB_COL_FILETYPE] = _L("File Type");
		vsColNames[FB_COL_FILESIZE] = _L("File Size");
		vsColNames[FB_COL_FILEDATE] = _L("Modified Date");

		return vsColNames.GetSize();
	}
	
	virtual int GetRowInfo(string strKey, vector<string> &vsRowInfo, bool bSource)
	{
		vsRowInfo.SetSize(FB_COL_NUMS);
		vsRowInfo[FB_COL_FILE] = strKey;
		vsRowInfo[FB_COL_CATEGORY] = "";
		vsRowInfo[FB_COL_FILETYPE] = "";
		vsRowInfo[FB_COL_FILESIZE] = GetFileSize(strKey, bSource);
		vsRowInfo[FB_COL_FILEDATE] = GetFileDate(strKey, bSource);
		return vsRowInfo.GetSize();
	}

	virtual int GetShownInfo(vector<bool>& vbShow)
	{
		vbShow.SetSize(FB_COL_NUMS);
		vbShow = false;
		vbShow[FB_COL_FILE] = true;
		vbShow[FB_COL_FILESIZE] = true;
		vbShow[FB_COL_FILEDATE] = true;

		return 3;
	}

	virtual bool GetFileFullPath(string &strFile1, string &strFile2)
	{
		strFile1 = m_strSrcPath + strFile1;
		strFile2 = m_strDestPath + strFile2;
		return true;
	}
	string GetSrcPath()
	{
		return m_strSrcPath;
	}
	string GetDestPath()
	{
		return m_strDestPath;
	}
	
	string GetFileSize(LPCSTR lpcszFile, bool bSource)
	{
		string strFile = lpcszFile;
		if(bSource)
			strFile = m_strSrcPath + strFile;
		else
			strFile = m_strDestPath + strFile;
		uint nSize;
		GetFileSize(strFile, &nSize);
		
		// always return the size in KB
		if(nSize > 1024)
			nSize = nSize/1024.0 + 0.5;
		else if(nSize > 0)
			nSize = 1;
		string strSize;
		strSize.Format("%d KB", nSize);
		return strSize;
	}
	
	string GetFileDate(LPCSTR lpcszFile, bool bSource)
	{
		string strFile = lpcszFile;
		if(bSource)
			strFile = m_strSrcPath + strFile;
		else
			strFile = m_strDestPath + strFile;
		return GetFileModificationDate(strFile, LDF_SHORT);
	}

protected:
	void GetFiles(LPCSTR lpcszPath, const vector<string> &vsFileExt, vector<string>& vsFiles)
	{
		vsFiles.SetSize(0);
		string strPath(lpcszPath);
		if(!strPath.IsPath())
			return;

		for(int ii = 0; ii < vsFileExt.GetSize(); ii++)
		{
			vector<string> vsFindFiles;
			FindFiles(vsFindFiles, lpcszPath, vsFileExt[ii]);
			vsFiles.Append(vsFindFiles);
		}		
	}

	int CopyFiles(vector<string> &vsFileNames, bool bForward = true)
	{
		ASSERT(bForward);
		if(vsFileNames.GetSize() == 0)
			return 0;

		// copy files
		int nFileCopied = 0;
		for (int ii = 0; ii < vsFileNames.GetSize(); ii++)
		{
			string strDestFile, strDestPath;
			strDestFile = vsFileNames[ii];
			if(bForward)
				strDestFile.Replace(m_strSrcPath, m_strDestPath);
			else
				strDestFile.Replace(m_strDestPath, m_strSrcPath);

			strDestPath = GetFilePath(strDestFile);
			if ( !strDestPath.IsPath() )
				CheckMakePath(strDestPath);

			if ( !copyfile(vsFileNames[ii], strDestFile, 0) )
				nFileCopied++;
			else
			{
				vsFileNames[ii].Empty();
			}
		}
		return nFileCopied;
	}

protected:
	virtual bool GetSourceDestFilePath()
	{
		m_strSrcPath = okutil_get_origin_path(ORIGIN_PATH_USER);
		m_strDestPath = GetGroupFolderPath();

		return true;
	}

	string GetGroupFolderPath(LPCSTR lpcszSubPath=NULL)
	{
		return okutil_get_origin_path(ORIGIN_PATH_SERVER_GROUP_FOLDER, lpcszSubPath, true);
	}
protected:
	string		m_strSrcPath;
	string		m_strDestPath;
};

static		void		_check_create_tempalte_xml(const string& strFile)
{
	if ( !strFile.IsFile() )
	{
		Tree trXML;
		load_template_tree(trXML);
		foreach (TreeNode trBranch in trXML.Children)
		{
			trBranch.Reset(true);
		}
		trXML.Save(strFile);
	}
}

class TemplatePublish : public FilePublishBase
{
public:

	virtual int GetFiles(bool bSource, vector<string>& vsFiles)
	{
		
		Tree trXML;
		if (!load_template_tree(trXML, bSource ? TEMPLATE_LOCATION_USER_FOLDER : TEMPLATE_LOCATION_SERVER_GROUP_FOLDER))
			return 0;
		
		tree_get_attributes(trXML, vsFiles, STR_FILENAME_ATTRIB);
		
		for (int ii=vsFiles.GetSize()-1; ii>=0; ii--)
		{
			if (vsFiles[ii].IsEmpty() || (bSource && template_get_origin_path_type(vsFiles[ii]) == ORIGIN_PATH_UNDEF))
				vsFiles.RemoveAt(ii);
			else
				vsFiles[ii] = GetFileName(vsFiles[ii]);
		}
		
		return vsFiles.GetSize();
		
	}

	virtual int PublishFiles(vector<string> &vsFileNames, bool bForward = true)
	{
		//Load template XML
		Tree trXML;		
		if (!load_template_tree(trXML, bForward ? TEMPLATE_LOCATION_USER_FOLDER : TEMPLATE_LOCATION_SERVER_GROUP_FOLDER))
			return 0;

		//if destination xml files not exist, create it
		Tree trTmp;
		string strPath = bForward ? STR_SERVER_GROUP_TEMPLATE_XML : STR_TEMPLATE_XML;
		
		_check_create_tempalte_xml(strPath);
		
		int nSize = vsFileNames.GetSize();
		vector<string> vsFileFullNames(nSize);
		vector<string> vsPictures;		
		
		string strPathFrom, strPathTo;
		if (bForward)
		{
			strPathFrom = m_strSrcPath;
			strPathTo = m_strDestPath;
		}
		else
		{
			strPathFrom = m_strDestPath;
			strPathTo = m_strSrcPath;
		}

		for (int ii=0; ii<nSize; ii++)
		{
			vsFileFullNames[ii] = strPathFrom + vsFileNames[ii];
			//add picture
			string strPicture = _check_get_pictrue_name(vsFileFullNames[ii]);
			if (!strPicture.IsEmpty())
				vsPictures.Add(strPicture);
			
			int nTemplateType = _get_template_type_from_name(vsFileNames[ii]);
			TreeNode trBranch = tree_get_node_by_id(trXML, nTemplateType);
			string strCate;

			findTemplate(trBranch, bForward ? vsFileFullNames[ii] : vsFileNames[ii], strCate);
			okutil_add_template(strPath, strCate, vsFileNames[ii], nTemplateType);
		}
		
		//copy files
		int nRet = CopyFiles(vsFileFullNames, bForward);
		if (nRet != nSize)
		{
			for (ii=nSize-1; ii>=0; ii--)
			{
				if (vsFileFullNames[ii].IsEmpty())
					vsFileNames.RemoveAt(ii);
			}
		}
		if (vsPictures.GetSize())
			CopyFiles(vsPictures, bForward);
		
		return nRet;
		
	}
	
	virtual int RemoveFiles(vector<string> &vsFileNames, bool bSource)
	{		
		//Load template XML
		Tree trXML;		
		if (!load_template_tree(trXML, bSource ? TEMPLATE_LOCATION_USER_FOLDER : TEMPLATE_LOCATION_SERVER_GROUP_FOLDER))
			return 0;
		
		int nSize = vsFileNames.GetSize();
		for (int ii=nSize-1; ii>=0; ii--)
		{
			string strFileFullName = (bSource ? m_strSrcPath : m_strDestPath) + vsFileNames[ii];
			TreeNode trNode = trXML.FindNodeByAttribute(STR_NAME_ATTRIB, vsFileNames[ii]);
			if (trNode)
				trNode.Remove();

			if (!bSource)
			{
				if (!okutil_delete_file(strFileFullName, true))
					vsFileNames.RemoveAt(ii);
				//delete picture
				string strPicture = _check_get_pictrue_name(strFileFullName);
				if (!strPicture.IsEmpty())
					okutil_delete_file(strPicture, true);
			}				
		}
		trXML.Save(bSource ? STR_TEMPLATE_XML : STR_SERVER_GROUP_TEMPLATE_XML);
		return vsFileNames.GetSize();
	}
	
private:
	bool findTemplate(TreeNode& trBranch, string strFile, string& strCate)
	{
		TreeNode tr;
		if(trBranch.IsValid())
			tr = trBranch.FindNodeByAttribute(STR_FILENAME_ATTRIB, strFile);
		if(!tr.IsValid() || !tr.Parent().IsValid())
			return false;
		tr = tr.Parent();
		tr.GetAttribute(STR_LABEL_ATTRIB, strCate);
		if(!lstrlen(strCate))
			strCate = tr.tagName;
		return true;
	}
};

class ImpFilterPublish : public FilePublishBase
{
public:
	ImpFilterPublish()
	{
		m_strSrcPath = okutil_get_origin_path(ORIGIN_PATH_USER, FILTERS_FOLDER_NAME, TRUE);
		m_strDestPath = GetGroupFolderPath(FILTERS_FOLDER_NAME);
	}

	virtual int GetFiles(bool bSource, vector<string>& vsFiles)
	{ 
		vector<string> vsExt = {IMPORT_FILTER_EXTENSION};
		string strPath;
		if(bSource)
			strPath = m_strSrcPath;
		else
			strPath = m_strDestPath;

		GetFiles(strPath, vsExt, vsFiles);
		return vsFiles.GetSize();
	}

	virtual int PublishFiles(vector<string> &vsFileNames, bool bForward = true)
	{ 
		int nSize = vsFileNames.GetSize();
		vector<string> vsFileFullNames(nSize);
		for (int ii=0; ii<nSize; ii++)
		{
			vsFileFullNames[ii] = (bForward ? m_strSrcPath : m_strDestPath) + vsFileNames[ii];
			bool bValue;

			string strGroupPath = GetGroupFolderPath();
			string strFileName = GetFilenameWithoutExt(vsFileNames[ii]);
			if (get_filter_setting(strFileName,
									bValue,
									bForward ? FILTER_LOCATION_USER_FOLDER : FILTER_LOCATION_GROUP_FOLDER,
									FILTER_SETTING_DRAG_AND_DROG,
									bForward ? "" : strGroupPath))
			{
				set_filter_setting(strFileName,
									bValue,
									bForward ? FILTER_LOCATION_GROUP_FOLDER : FILTER_LOCATION_USER_FOLDER,
									FILTER_SETTING_DRAG_AND_DROG,
									bForward ? strGroupPath : "");
			}
		}
		int nRet = CopyFiles(vsFileFullNames, bForward);
		
		if (nRet != nSize)
		{
			for (ii=nSize-1; ii>=0; ii--)
			{
				if (vsFileFullNames[ii].IsEmpty())
					vsFileNames.RemoveAt(ii);
			}
		}
		
		return nRet;
	}
	
	virtual int RemoveFiles(vector<string> &vsFileNames, bool bSource)
	{
		int nSize = vsFileNames.GetSize();
		for (int ii=nSize-1; ii>=0; ii--)
		{
			string strFileFullName = (bSource ? m_strSrcPath : m_strDestPath) + vsFileNames[ii];
			bool bValue;
			string strGroupPath = GetGroupFolderPath();
			string strFileName = GetFilenameWithoutExt(vsFileNames[ii]);
			if (get_filter_setting(strFileName,
									bValue,
									bSource ? FILTER_LOCATION_USER_FOLDER : FILTER_LOCATION_GROUP_FOLDER,
									FILTER_SETTING_DRAG_AND_DROG,
									bSource ? "" : strGroupPath))
			{
				remove_line_from_filter_setting(strFileName,
												bSource ? FILTER_LOCATION_USER_FOLDER : FILTER_LOCATION_GROUP_FOLDER,
												FILTER_SETTING_DRAG_AND_DROG,
												bSource ? "" : strGroupPath);
			}

			if (!okutil_delete_file(strFileFullName, true))
				vsFileNames.RemoveAt(ii);
		}
		return vsFileNames.GetSize();
	}
};

class FDFPublish : public FilePublishBase
{
public:
	FDFPublish()
	{
		m_strSrcPath = okutil_get_origin_path(ORIGIN_PATH_USER, NULL, TRUE) + STR_FDF_FILE_FOLDER_BACKSLASH;
		m_strDestPath = GetGroupFolderPath(STR_FDF_FILE_FOLDER_BACKSLASH);
	}

	virtual int GetFiles(bool bSource, vector<string>& vsFiles)
	{ 
		vector<string> vsFunctions;

		FDFPaths fdfPaths;
		fdfPaths.strFilePath = bSource ? m_strSrcPath : m_strDestPath;
		fdfPaths.strIniPath = okutil_get_origin_path(bSource ? ORIGIN_PATH_USER : ORIGIN_PATH_SERVER_GROUP_FOLDER, NULL, TRUE);
		fdfPaths.strSysPath = okutil_get_origin_path(ORIGIN_PATH_SYSTEM);
		m_gfo.GetFilesList(vsFunctions, vsFiles, fdfPaths);

		return _append_file_ext(vsFiles, STR_FDF_FILE_EXT);
	}

	virtual int PublishFiles(vector<string> &vsFileNames, bool bForward = true)
	{ 
		int nNum = 0;

		FDFPaths fdfSrcPaths, fdfDestPaths;
		fdfSrcPaths.strFilePath = m_strSrcPath;
		fdfSrcPaths.strIniPath = okutil_get_origin_path(ORIGIN_PATH_USER);
		fdfSrcPaths.strSysPath = okutil_get_origin_path(ORIGIN_PATH_SYSTEM);
		fdfDestPaths.strFilePath = m_strDestPath;
		fdfDestPaths.strIniPath = GetGroupFolderPath();
		fdfDestPaths.strSysPath = fdfSrcPaths.strSysPath;

		for (int ii = 0; ii < vsFileNames.GetSize(); ii++)
		{
			string strFile = vsFileNames[ii];
			strFile.Replace(STR_FDF_FILE_EXT, "");

			if ( m_gfo.AddFile(strFile, bForward ? fdfSrcPaths : fdfDestPaths, bForward ? fdfDestPaths : fdfSrcPaths) )
				nNum++;
			else
				vsFileNames.RemoveAt(ii--);
		}
		
		return nNum;
	}

	virtual int RemoveFiles(vector<string> &vsFileNames, bool bSource)
	{
		int nNum = 0;

		FDFPaths fdfPaths;
		fdfPaths.strFilePath = bSource ? m_strSrcPath : m_strDestPath;
		fdfPaths.strIniPath = bSource ? okutil_get_origin_path(ORIGIN_PATH_USER) : GetGroupFolderPath();
		fdfPaths.strSysPath = okutil_get_origin_path(ORIGIN_PATH_SYSTEM);

		for (int ii = 0; ii < vsFileNames.GetSize(); ii++)
		{
			string strFile = vsFileNames[ii];
			strFile.Replace(STR_FDF_FILE_EXT, "");
			if ( m_gfo.RemoveFile(strFile, fdfPaths, bSource) )
				nNum++;
			else
				vsFileNames.RemoveAt(ii--);
		}
		
		return nNum;
	}
	
private:
	GroupFunctionOrganizer	m_gfo;
};

class OGSPublish : public FilePublishBase
{
public:

	virtual int GetFiles(bool bSource, vector<string>& vsFiles)
	{
		vector<string> vsExt = {".ogs"};
		GetFiles(bSource ? m_strSrcPath : m_strDestPath, vsExt, vsFiles);
		return vsFiles.GetSize();
	}
};

class FileCategoryPublish : public FilePublishBase
{
	FileCategoryPublish(string strFileExts)
	{
		strFileExts.GetTokens(m_vsFileExts, '|');
	}

	virtual int GetRowInfo(string strKey, vector<string> &vsRowInfo, bool bSource)
	{
		vsRowInfo.SetSize(FB_COL_NUMS);
		vsRowInfo[FB_COL_FILE] 		= GetFileName(strKey);
		vsRowInfo[FB_COL_CATEGORY] 	= GetFilePath(strKey);
		vsRowInfo[FB_COL_FILETYPE] 	= "";
		vsRowInfo[FB_COL_FILESIZE] 	= GetFileSize(strKey, bSource);
		vsRowInfo[FB_COL_FILEDATE] 	= GetFileDate(strKey, bSource);
		return vsRowInfo.GetSize();
	}
	
	virtual int GetShownInfo(vector<bool>& vbShow)
	{
		vbShow.SetSize(FB_COL_NUMS);
		vbShow = false;
		vbShow[FB_COL_FILE] =
		vbShow[FB_COL_FILESIZE] =
		vbShow[FB_COL_FILEDATE] = true;

		return 3;		// shown cols
	}

	virtual int GetFiles(bool bSource, vector<string>& vsFiles)
	{
		for (int ii=0; ii<m_vsFileExts.GetSize(); ii++)
		{
			string strFile;
			GetFilenamesInFolder(strFile, bSource ? m_strSrcPath : m_strDestPath, m_vsFileExts[ii], true);
			vector<string> vsTmp;
			strFile.GetTokens(vsTmp, '|');
			vsFiles.Append(vsTmp);
		}
		int nSize = vsFiles.GetSize();

		if (bSource)
		{
			m_vsXFUserFullFiles = vsFiles;
			m_vsXFUserFiles.SetSize(nSize);
		}
		else
		{
			m_vsXFGroupFullFiles = vsFiles;
			m_vsXFGroupFiles.SetSize(nSize);
		}
		for (ii=0; ii<nSize; ii++)
		{
			if (bSource)
			{
				vsFiles[ii].Replace(m_strSrcPath, "");
				m_vsXFUserFiles[ii] = vsFiles[ii];
			}
			else
			{
				vsFiles[ii].Replace(m_strDestPath, "");
				m_vsXFGroupFiles[ii] = vsFiles[ii];
			}
		}
		return nSize;
	}

	virtual int PublishFiles(vector<string> &vsFileNames, bool bForward = true)
	{
		int nSize = vsFileNames.GetSize();
		
		vector<string> vsFileFullNames(nSize);
		if (bForward)
		{
			for(int ii=0; ii<nSize; ii++)
			{
				int nIndex = m_vsXFUserFiles.Find(vsFileNames[ii]);
				vsFileFullNames[ii] = m_vsXFUserFullFiles[nIndex];
				if (m_vsXFGroupFiles.Find(vsFileNames[ii]) < 0)
				{
					m_vsXFGroupFiles.Add(vsFileNames[ii]);
					m_vsXFGroupFullFiles.Add(vsFileFullNames[ii]);
					m_vsXFGroupFullFiles[m_vsXFGroupFullFiles.GetSize()-1].Replace(m_strSrcPath, m_strDestPath);
				}
			}
		}
		else
		{
			for(int ii=0; ii<nSize; ii++)
			{
				int nIndex = m_vsXFGroupFiles.Find(vsFileNames[ii]);
				vsFileFullNames[ii] = m_vsXFGroupFullFiles[nIndex];
				if (m_vsXFUserFiles.Find(vsFileNames[ii]) < 0)
				{
					m_vsXFUserFiles.Add(vsFileNames[ii]);
					m_vsXFUserFullFiles.Add(vsFileFullNames[ii]);
					m_vsXFUserFullFiles[m_vsXFUserFullFiles.GetSize()-1].Replace(m_strDestPath, m_strSrcPath);
				}
			}
		}

		int nRet = CopyFiles(vsFileFullNames, bForward);
		if (nRet != nSize)
		{
			for (int ii=nSize-1; ii>=0; ii--)
			{
				if (vsFileFullNames[ii].IsEmpty())
				{
					if (bForward)
					{
						int nIndex = m_vsXFUserFiles.Find(vsFileNames[ii]);
						m_vsXFUserFiles.RemoveAt(nIndex);
						m_vsXFUserFullFiles.RemoveAt(nIndex);
					}
					else
					{
						int nIndex = m_vsXFGroupFiles.Find(vsFileNames[ii]);
						m_vsXFGroupFiles.RemoveAt(nIndex);
						m_vsXFGroupFullFiles.RemoveAt(nIndex);
					}
					vsFileNames.RemoveAt(ii);
				}
			}
		}
		
		return nRet;
	}

	virtual int RemoveFiles(vector<string> &vsFileNames, bool bSource)
	{
		int nSize = vsFileNames.GetSize();
		if (bSource == false)
		{
			for (int ii=nSize-1; ii>=0; ii--)
			{
				int nIndex = m_vsXFGroupFiles.Find(vsFileNames[ii]);
				if (okutil_delete_file(m_vsXFGroupFullFiles[nIndex], true))
				{
					m_vsXFGroupFiles.RemoveAt(nIndex);
					m_vsXFGroupFullFiles.RemoveAt(nIndex);
				}
				else
				{
					vsFileNames.RemoveAt(ii);
				}
			}
		}
		else
		{
			for (int ii=nSize-1; ii>=0; ii--)
			{
				int nIndex = m_vsXFUserFiles.Find(vsFileNames[ii]);
				if (okutil_delete_file(m_vsXFUserFullFiles[nIndex], true))
				{
					m_vsXFUserFiles.RemoveAt(nIndex);
					m_vsXFUserFullFiles.RemoveAt(nIndex);
				}
				else
				{
					vsFileNames.RemoveAt(ii);
				}
			}
		}
		return vsFileNames.GetSize();
	}
	
protected:
		
	vector<string> 	m_vsXFUserFiles;
	vector<string> 	m_vsXFGroupFiles;
	vector<string> 	m_vsXFUserFullFiles;
	vector<string> 	m_vsXFGroupFullFiles;
	vector<string>	m_vsFileExts;
};


#define STR_THEME_FILE_FOLDER			"Themes\\"

class ThemePublish : public FileCategoryPublish
{
public:
	ThemePublish() : FileCategoryPublish("*.oth")
	{
		m_strSrcPath = okutil_get_origin_path(ORIGIN_PATH_USER, STR_THEME_FILE_FOLDER, TRUE);
		m_strDestPath = GetGroupFolderPath(STR_THEME_FILE_FOLDER);
	}
};

class XFPublish : public FileCategoryPublish
{
public:
	XFPublish() : FileCategoryPublish("*.oxf")
	{
		m_strSrcPath = okutil_get_origin_path(ORIGIN_PATH_USER, STR_XF_FILE_FOLDER, TRUE);
		m_strDestPath = GetGroupFolderPath(STR_XF_FILE_FOLDER);
	}
};

class DefaultSettingsPublish : public FilePublishBase
{
public:
	virtual int GetFiles(bool bSource, vector<string>& vsFiles)
	{
		FindFiles(vsFiles, bSource ? m_strSrcPath : m_strDestPath, "Defaults.xml");
		return vsFiles.GetSize();
	}
};

class ProjectPublish : public FilePublishBase
{
public:
	ProjectPublish(string strFileExt, LPCSTR lpcszSubPath = NULL)
	{
		if( lpcszSubPath )
		{
			m_strSrcPath += lpcszSubPath;
			m_strDestPath += lpcszSubPath;
		}

		m_strFileExt = strFileExt;
	}

	virtual int GetFiles(bool bSource, vector<string>& vsFiles)
	{
		vector<string> vsExt;
		m_strFileExt.GetTokens(vsExt, '|');
		string strPath;
		if(bSource)
			strPath = m_strSrcPath;
		else
			strPath = m_strDestPath;
		GetFiles(strPath, vsExt, vsFiles);
		return vsFiles.GetSize();
	}

	virtual int PublishFiles(vector<string> &vsFileNames, bool bForward = true)
	{
		return FilePublishBase::PublishFiles(vsFileNames, bForward);
	}

private:
	string m_strFileExt;	//------ Folger 09/14/07 REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR
};

class OMCPublish : public ProjectPublish
{
public:
	OMCPublish() : ProjectPublish(STR_OMC_FILE_EXT)
	{
	}

	int PublishFiles(vector<string> &vsFileNames, bool bForward = true)
	{
		vsFileNames.Add(MENU_CUSTOMIZATION_CONFIGURATION_FILE);
		return ProjectPublish::PublishFiles(vsFileNames, bForward);
	}
};

class OriginCPublish : public FilePublishBase
{
public:
	OriginCPublish()
	{
		m_strSrcPath += "OriginC\\";
		m_strDestPath += "OriginC\\";
	}
	
	virtual int GetFiles(bool bSource, vector<string>& vsFiles)
	{
		vector<string> vsExt = {".h", ".c", ".cpp"};
		string strPath;
		if(bSource)
			strPath = m_strSrcPath;
		else
			strPath = m_strDestPath;
		GetFiles(strPath, vsExt, vsFiles);
		return vsFiles.GetSize();
	}

	virtual int PublishFiles(vector<string> &vsFileNames, bool bForward = true)
	{
		return FilePublishBase::PublishFiles(vsFileNames, bForward);
	}
	
private:
};

#define STR_UPDATE_FOLDER		"Updates\\"
#define STR_UPDATE_INI_FILE		"update.ini"
#define STR_SECTION_PATCH		"patch8"
#define STR_KEY_BUILD			"build"

class PatchPublish : public FilePublishBase
{
public:
	PatchPublish()
	{
		m_strSrcPath = okutil_get_origin_path(ORIGIN_PATH_SYSTEM, STR_UPDATE_FOLDER, TRUE);
		m_strDestPath = GetGroupFolderPath(STR_UPDATE_FOLDER);
	}

	virtual int GetFiles(bool bSource, vector<string>& vsFiles)
	{
		vector<string> vsExt = {".exe"};
		string strPath = bSource ? m_strSrcPath : m_strDestPath;
		GetFiles(strPath, vsExt, vsFiles);
		return vsFiles.GetSize();
	}

	virtual int PublishFiles(vector<string> &vsFileNames, bool bForward = true)
	{
		int nSize = vsFileNames.GetSize();
		CheckMakePath(bForward ? m_strDestPath : m_strSrcPath);

		for (int ii=nSize-1; ii>=0; ii--)
		{
			if (bForward)
			{
				if (copyfile(m_strSrcPath + vsFileNames[ii], m_strDestPath + vsFileNames[ii], 0))
					vsFileNames.RemoveAt(ii);
			}
			else
			{
				if (copyfile(m_strDestPath + vsFileNames[ii], m_strSrcPath + vsFileNames[ii], 0))
					vsFileNames.RemoveAt(ii);
			}
		}

		if (bForward)
			checkSetUpdateINI();
		return vsFileNames.GetSize();
	}

	virtual int RemoveFiles(vector<string> &vsFileNames, bool bSource)
	{
		FilePublishBase::RemoveFiles(vsFileNames, bSource);
		if (!bSource)
			checkSetUpdateINI();
		return vsFileNames.GetSize();
	}
	
private:
	
	bool checkSetUpdateINI()
	{
		vector<string> vsFiles;
		GetFiles(ORIGIN_PATH_SERVER_GROUP_FOLDER, vsFiles);
		int nSize = vsFiles.GetSize();
		
		int nNewBuildTo = 0;
		for (int ii=0; ii<nSize; ii++)
		{
			int nBuildFrom, nBuildTo;
			get_patch_build_version(vsFiles[ii], &nBuildTo, &nBuildFrom);
			if (nBuildTo > nNewBuildTo)
				nNewBuildTo = nBuildTo;
		}
		INIFile iniFile(okutil_get_origin_path(ORIGIN_PATH_SERVER_GROUP_FOLDER) + STR_UPDATE_INI_FILE);
		iniFile.WriteInt(STR_SECTION_PATCH, STR_KEY_BUILD, nNewBuildTo);
		
		return true;
	}
	
};

#define STR_DIALOG_THEME_FOLDER	"Themes\\AnalysisAndReportTable\\"

class DialogThemePublish : public FilePublishBase
{
public:
	
	DialogThemePublish()
	{
		m_strSrcPath = okutil_get_origin_path(ORIGIN_PATH_USER, STR_DIALOG_THEME_FOLDER, TRUE);
		m_strDestPath = GetGroupFolderPath(STR_DIALOG_THEME_FOLDER);
	}

	virtual int GetFiles(bool bSource, vector<string>& vsFiles)
	{
		vector<string> vsExt = {".ois"};
		string strPath;
		strPath = bSource ? m_strSrcPath : m_strDestPath;
		GetFiles(strPath, vsExt, vsFiles);
		
		int nSize = vsFiles.GetSize();
		for (int ii=nSize-1; ii>=0; ii--)
		{
			string strName, strTool, strScope, strCategory;
			theme_filename_to_options(vsFiles[ii], strName, strTool, strScope ,strCategory);
			if (is_theme_last_used(GetFileName(strName, true)))
				vsFiles.RemoveAt(ii);
		}
		
		return vsFiles.GetSize();
	}

};

class FileTransferBase : public FilePublishBase
{
public:
	FileTransferBase(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath)
	{
		m_strRegistryKey = lpcszRegKey;
		m_strSpecifiedPath = lpcszSpecifiedPath;
		m_bSrcPathSpecified = false;
		GetSourceDestFilePath();
	}
	
	//virtual
	int GetColNames(vector<string> &vsColNames, bool bSource)
	{
		vsColNames.SetSize(FB_COL_NUMS);
		if(bSource)
			vsColNames[FB_COL_FILE] = _L(m_strRegistryKey);
		else
		{
			string strFile;
			strFile.Format(_L("%s User Files"), ftoa(CURRENT_VERSION));
			vsColNames[FB_COL_FILE] = strFile;
		}
		vsColNames[FB_COL_CATEGORY] = _L("Category");
		vsColNames[FB_COL_FILETYPE] = _L("File Type");
		vsColNames[FB_COL_FILESIZE] = _L("File Size");
		vsColNames[FB_COL_FILEDATE] = _L("Modified Date");

		return vsColNames.GetSize();
	}
	
	virtual bool IsSrcPathSpecified()
	{
		return m_bSrcPathSpecified;
	}
protected:
	// virtual
	bool GetSourceDestFilePath()
	{
		m_strDestPath = okutil_get_origin_path(ORIGIN_PATH_USER);

		if(get_origin_user_path(m_strSrcPath, m_strRegistryKey, true))
		{
			m_bSrcPathSpecified = false;
		}
		else
		{
			m_bSrcPathSpecified = true;
			m_strSrcPath = m_strSpecifiedPath;
		}
		m_strSrcPath.TrimRight("\\");
		if(m_strSrcPath.IsEmpty())
			return false;
		m_strSrcPath += "\\";
		if(!m_strSrcPath.IsPath())
		{
			m_strSrcPath.Empty();
			return false;
		}

		return true;
	}

protected:
	string		m_strRegistryKey;
	string		m_strSpecifiedPath;
	bool		m_bSrcPathSpecified;
};

class FileCategoryTransfer : public FileTransferBase
{
public:
	FileCategoryTransfer(string strFileExts, LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) : FileTransferBase(lpcszRegKey, lpcszSpecifiedPath)
	{
		strFileExts.GetTokens(m_vsFileExts, '|');
	}

	virtual bool GetFileFullPath(string &strFile1, string &strFile2)
	{
		if(IsSrcPathSpecified())					// trim the category info
			strFile1 = m_strSrcPath + GetFileName(strFile1);
		else
			strFile1 = m_strSrcPath + strFile1;
		strFile2 = m_strDestPath + strFile2;
		return true;
	}
	
	virtual int GetRowInfo(string strKey, vector<string> &vsRowInfo, bool bSource)
	{
		vsRowInfo.SetSize(FB_COL_NUMS);
		vsRowInfo[FB_COL_FILE] 		= GetFileName(strKey);
		vsRowInfo[FB_COL_CATEGORY] 	= GetFilePath(strKey);
		vsRowInfo[FB_COL_FILETYPE] 	= "";
		vsRowInfo[FB_COL_FILESIZE] 	= GetFileSize(strKey, bSource);
		vsRowInfo[FB_COL_FILEDATE] 	= GetFileDate(strKey, bSource);

		return vsRowInfo.GetSize();
	}
	
	virtual int GetShownInfo(vector<bool>& vbShow)
	{
		vbShow.SetSize(FB_COL_NUMS);
		vbShow = false;
		vbShow[FB_COL_FILE] =
		vbShow[FB_COL_FILESIZE] =
		vbShow[FB_COL_FILEDATE] = true;

		return 3;	// shown cols
	}

	virtual int GetFiles(bool bSource, vector<string>& vsFiles)
	{
		bool bRecursive = !(bSource && m_bSrcPathSpecified);
		for (int ii=0; ii<m_vsFileExts.GetSize(); ii++)
		{
			string strFile;
			GetFilenamesInFolder(strFile, bSource ? m_strSrcPath : m_strDestPath, m_vsFileExts[ii], bRecursive);
			vector<string> vsTmp;
			strFile.GetTokens(vsTmp, '|');
			vsFiles.Append(vsTmp);
		}
		int nSize = vsFiles.GetSize();

		if (bSource)
		{
			m_vsXFSrcFullFiles = vsFiles;
			m_vsXFSrcFiles.SetSize(nSize);
		}
		else
		{
			m_vsXFDestFullFiles = vsFiles;
			m_vsXFDestFiles.SetSize(nSize);
		}
		for (ii=0; ii<nSize; ii++)
		{
			if (bSource)
			{
				vsFiles[ii].Replace(m_strSrcPath, "");
				m_vsXFSrcFiles[ii] = vsFiles[ii];
			}
			else
			{
				vsFiles[ii].Replace(m_strDestPath, "");
				m_vsXFDestFiles[ii] = vsFiles[ii];
			}
		}
		return nSize;
	}

	virtual int PublishFiles(vector<string> &vsFileNames, bool bForward = true)
	{
		ASSERT(bForward);

		int nSize = vsFileNames.GetSize();
		vector<string> vsFileFullNames(nSize);

		for(int ii=0; ii<nSize; ii++)
		{
			if(m_bSrcPathSpecified)
			{
				string strFileName = GetFileName(vsFileNames[ii]);
				int nIndex = m_vsXFSrcFiles.Find(strFileName);
				vsFileFullNames[ii] = m_vsXFSrcFullFiles[nIndex];
				string strDestFile = GetDestCategory() + strFileName;
				vsFileNames[ii] = strDestFile;									// will use this to update the dest list
				if (m_vsXFDestFiles.Find(strDestFile) < 0)
				{
					m_vsXFDestFiles.Add(strDestFile);
					m_vsXFDestFullFiles.Add(m_strDestPath + strDestFile);
				}
			}
			else
			{
				int nIndex = m_vsXFSrcFiles.Find(vsFileNames[ii]);
				vsFileFullNames[ii] = m_vsXFSrcFullFiles[nIndex];
				if (m_vsXFDestFiles.Find(vsFileNames[ii]) < 0)
				{
					m_vsXFDestFiles.Add(vsFileNames[ii]);
					m_vsXFDestFullFiles.Add(m_vsXFSrcFullFiles[nIndex]);
					m_vsXFDestFullFiles[m_vsXFDestFullFiles.GetSize()-1].Replace(m_strSrcPath, m_strDestPath);
				}
			}
		}
		int nRet = CopyFiles(vsFileFullNames, bForward);
		if (nRet != nSize)
		{
			for (int ii=nSize-1; ii>=0; ii--)
			{
				if (vsFileFullNames[ii].IsEmpty())
				{
					int nIndex = m_vsXFSrcFiles.Find(vsFileNames[ii]);
					m_vsXFSrcFiles.RemoveAt(nIndex);
					m_vsXFSrcFullFiles.RemoveAt(nIndex);
					vsFileNames.RemoveAt(ii);
				}
			}
		}
		return nRet;
	}

	virtual int RemoveFiles(vector<string> &vsFileNames, bool bSource)
	{
		ASSERT(bSource == false);

		int nSize = vsFileNames.GetSize();
		for (int ii=nSize-1; ii>=0; ii--)
		{
			int nIndex = m_vsXFDestFiles.Find(vsFileNames[ii]);
			if (okutil_delete_file(m_vsXFDestFullFiles[nIndex], true))
			{
				m_vsXFDestFiles.RemoveAt(nIndex);
				m_vsXFDestFullFiles.RemoveAt(nIndex);
			}
			else
			{
				vsFileNames.RemoveAt(ii);
			}
		}

		return vsFileNames.GetSize();
	}
protected:
	
	virtual int CopyFiles(vector<string> &vsFileNames, bool bForward = true)
	{
		ASSERT(bForward);
		if(vsFileNames.GetSize() == 0)
			return 0;
		if(m_bSrcPathSpecified == false)
			return FileTransferBase::CopyFiles(vsFileNames, bForward);

		// it needs specifying a category, special handle
		string strDestPath = m_strDestPath + GetDestCategory();
		if ( !strDestPath.IsPath() )
			CheckMakePath(strDestPath);

		int nFileCopied = 0;
		for(int ii=vsFileNames.GetSize()-1; ii>=0; ii--)
		{
			string strFileName = GetFileName(vsFileNames[ii]);
			string strDestFile = strDestPath + strFileName;
			if ( !copyfile(vsFileNames[ii], strDestFile, 0) )
				nFileCopied++;
			else
				vsFileNames[ii].Empty();
		}
		return nFileCopied;
	}
	
protected:
		
	vector<string> 	m_vsXFSrcFiles;
	vector<string> 	m_vsXFDestFiles;
	vector<string> 	m_vsXFSrcFullFiles;
	vector<string> 	m_vsXFDestFullFiles;
	vector<string>	m_vsFileExts;
};

class ThemeTransfer : public FileCategoryTransfer
{
public:
	ThemeTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) : FileCategoryTransfer("*.oth", lpcszRegKey, lpcszSpecifiedPath)
	{
		if(!m_bSrcPathSpecified)
			m_strSrcPath += STR_THEME_FILE_FOLDER;
		m_strDestPath += STR_THEME_FILE_FOLDER;
		
		// hard code, available categories
		m_vsCategories.SetSize(0);
		m_vsCategories.Add("Graph");
		m_vsCategories.Add("Worksheet");
	}
	
	virtual int GetFiles(bool bSource, vector<string>& vsFiles)
	{
		int nFiles = FileCategoryTransfer::GetFiles(bSource, vsFiles);
		///Kyle 08/04/2010 ORG-710-P1 SHOW_ONLY_GRAPH_OR_WORKSHEET_THEME_IF_PATH_SPECIFIED
		//if(bSource && m_bSrcPathSpecified)		// no need to check the category
		//	return nFiles;
		bool bCheckCate = m_bSrcPathSpecified && !m_strDestCategory.IsEmpty();
		///End SHOW_ONLY_GRAPH_OR_WORKSHEET_THEME_IF_PATH_SPECIFIED

		for(int ii=nFiles-1; ii>=0; ii--)
		{
			string strPath = GetFilePath(vsFiles[ii]);

			bool bDiffCate = bCheckCate && m_strDestCategory.CompareNoCase(strPath);		///Kyle 08/04/2010 ORG-710-P1 SHOW_ONLY_GRAPH_OR_WORKSHEET_THEME_IF_PATH_SPECIFIED

			strPath.TrimRight("\\");
			///Kyle 08/04/2010 ORG-710-P1 SHOW_ONLY_GRAPH_OR_WORKSHEET_THEME_IF_PATH_SPECIFIED
			//if(m_vsCategories.Find(strPath) < 0)
			if( bDiffCate || m_vsCategories.Find(strPath) < 0 )
			///End SHOW_ONLY_GRAPH_OR_WORKSHEET_THEME_IF_PATH_SPECIFIED
			{
				if (bSource)
				{
					m_vsXFSrcFullFiles.RemoveAt(ii);
					m_vsXFSrcFiles.RemoveAt(ii);
				}
				else
				{
					m_vsXFDestFullFiles.RemoveAt(ii);
					m_vsXFDestFiles.RemoveAt(ii);
				}
				vsFiles.RemoveAt(ii);
				nFiles--;
			}
		}
		return nFiles;
	}

	virtual void SetDestCategory(LPCSTR lpcszCategory)
	{
		m_strDestCategory = lpcszCategory;
		m_strDestCategory.TrimRight("\\");
		m_strDestCategory += "\\";
	}

	virtual int	GetAvailableCates(vector<string>& vsCategories)
	{
		if(m_bSrcPathSpecified)
		{
			vsCategories = m_vsCategories;
			return vsCategories.GetSize();
		}
		else
		{
			vsCategories.SetSize(0);
			return 0;
		}
	}

	virtual string GetDestCategory(LPCSTR lpcszFile = NULL)
	{
		return m_strDestCategory;
	}
	
protected:
	vector<string>		m_vsCategories;
	string				m_strDestCategory;
};


class XFTransfer : public FileCategoryTransfer
{
public:
	XFTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) : FileCategoryTransfer("*.oxf", lpcszRegKey, lpcszSpecifiedPath)
	{
		if(m_bSrcPathSpecified == false)
			m_strSrcPath += STR_XF_FILE_FOLDER + "\\";
		m_strDestPath += STR_XF_FILE_FOLDER + "\\";
	}

	virtual string GetDestCategory(LPCSTR lpcszFile = NULL)
	{
		return "Miscellaneous\\";
	}
};


#define STR_TEMPLATE_INI		"template.ini"

class TemplateTransfer : public FileTransferBase
{
public:
	TemplateTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) : FileTransferBase(lpcszRegKey, lpcszSpecifiedPath)
	{
	}
	
	virtual int GetFiles(bool bSource, vector<string>& vsFiles)
	{
		string strPath;
		if(bSource)
			strPath = m_strSrcPath;
		else
			strPath = m_strDestPath;
		vector<string> vsFileExts = {".otp", ".otw", ".otm"};
		GetFiles(strPath, vsFileExts, vsFiles);

		return vsFiles.GetSize();
	}
	
	virtual int PublishFiles(vector<string> &vsFileNames, bool bForward = true)
	{
		ASSERT(bForward);
		int nSize = vsFileNames.GetSize();
		vector<string> vsFileFullNames(nSize);
		vector<string> vsPictures;
		
		_check_create_tempalte_xml(STR_TEMPLATE_XML);
		for (int ii=0; ii<nSize; ii++)
		{
			string strCate = getTemplateSection(vsFileNames[ii]);
			if (strCate.IsEmpty())
				strCate = m_strRegistryKey;
			
			int nTemplateType = _get_template_type_from_name(vsFileNames[ii]);
			vsFileFullNames[ii] = m_strSrcPath + vsFileNames[ii];
			
			okutil_add_template(STR_TEMPLATE_XML, strCate, vsFileNames[ii], nTemplateType);

			string strPicture = _check_get_pictrue_name(vsFileFullNames[ii]);
			if (!strPicture.IsEmpty())
				vsPictures.Add(strPicture);
		}
		int nRet = CopyFiles(vsFileFullNames, bForward);
		if (nRet != nSize)
		{
			for (ii=nSize-1; ii>=0; ii--)
			{
				if (vsFileFullNames[ii].IsEmpty())
					vsFileNames.RemoveAt(ii);
			}
		}
		if (vsPictures.GetSize())
			CopyFiles(vsPictures, bForward);
		
		return nRet;
	}

	virtual int RemoveFiles(vector<string> &vsFileNames, bool bSource)
	{		
		ASSERT(!bSource);
		Tree trXML;
		if (!load_template_tree(trXML, TEMPLATE_LOCATION_USER_FOLDER))
			return 0;

		int nSize = vsFileNames.GetSize();
		for (int ii=nSize-1; ii>=0; ii--)
		{
			string strFileFullName = m_strDestPath + vsFileNames[ii];
			TreeNode trNode = trXML.FindNodeByAttribute(STR_NAME_ATTRIB, vsFileNames[ii]);
			if (trNode)
				trNode.Remove();

			if (!okutil_delete_file(strFileFullName, true))
				vsFileNames.RemoveAt(ii);
			//delete picture
			string strPicture = _check_get_pictrue_name(strFileFullName);
			if (!strPicture.IsEmpty())
				okutil_delete_file(strPicture, true);
		}
		trXML.Save(m_strDestPath + STR_TEMPLATE_XML);
		return vsFileNames.GetSize();
	}
	
private:
	
	string getTemplateSection(string strFile)
	{
		INIFile ini(m_strSrcPath + STR_TEMPLATE_INI);
		string strFileName = GetFileName(strFile, true);
		
		vector<string> vsSections;
		ini.GetSectionNames(vsSections);
		
		int nSize = vsSections.GetSize();
		for (int ii=1; ii<nSize; ii++)
		{
			vector<string> vsKeys;
			ini.GetKeyNames(vsKeys, vsSections[ii]);
			int nKeySize = vsKeys.GetSize();
			for (int jj=0; jj<nKeySize; jj++)
			{
				string strKeyValue = ini.ReadString(vsSections[ii], vsKeys[jj]);
				strKeyValue.TrimLeft();
				strKeyValue.TrimRight();
				if( (!strKeyValue.IsEmpty() && strFile.CompareNoCase(strKeyValue)==0 ) || (strKeyValue.IsEmpty() && strFileName.CompareNoCase(vsKeys[jj])==0) )
					return vsSections[ii];
			}
		}		
		return "";
	}
	
private:

};

class ImpFilterTransfer : public FileTransferBase
{
public:
	ImpFilterTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) : FileTransferBase(lpcszRegKey, lpcszSpecifiedPath)
	{
		if(!m_bSrcPathSpecified)
			m_strSrcPath += FILTERS_FOLDER_NAME;
		m_strDestPath += FILTERS_FOLDER_NAME;
	}
	
	virtual int GetFiles(bool bSource, vector<string>& vsFiles)
	{ 
		vector<string> vsExt = {IMPORT_FILTER_EXTENSION};
		GetFiles(bSource ? m_strSrcPath : m_strDestPath, vsExt, vsFiles);
		return vsFiles.GetSize();
	}
};

class FDFTransfer : public FileTransferBase
{
public:
	FDFTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) : FileTransferBase(lpcszRegKey, lpcszSpecifiedPath)
	{
		if(!m_bSrcPathSpecified)
			m_strSrcPath += STR_FDF_FILE_FOLDER_BACKSLASH;
		m_strDestPath += STR_FDF_FILE_FOLDER_BACKSLASH;
	}

	virtual int GetFiles(bool bSource, vector<string>& vsFiles)
	{ 
		if(bSource && m_bSrcPathSpecified)
		{
			vsFiles.SetSize(0);
			FindFiles(vsFiles, m_strSrcPath, STR_FDF_FILE_EXT);
			return vsFiles.GetSize();
		}

		vector<string> vsFullFileNames;

		FDFPaths fdfPaths;
		GetFDFPaths(bSource, fdfPaths);
		m_gfo.GetFilesList(vsFiles, vsFullFileNames, fdfPaths);

		return _append_file_ext(vsFiles, STR_FDF_FILE_EXT);
	}

	virtual int PublishFiles(vector<string> &vsFileNames, bool bForward = true)
	{ 
		int nNum = 0;
		ASSERT(bForward);
		FDFPaths fdfSrcPaths, fdfDestPaths;
		GetFDFPaths(true, fdfSrcPaths);
		GetFDFPaths(false, fdfDestPaths);
		for (int ii = 0; ii < vsFileNames.GetSize(); ii++)
		{
			string strFile = vsFileNames[ii];
			strFile.MakeLower();			///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL, Replace may fails
			strFile.Replace(STR_FDF_FILE_EXT, "");
			if ( m_gfo.AddFile(strFile, fdfSrcPaths, fdfDestPaths) )
				nNum++;
			else
				vsFileNames.RemoveAt(ii--);
		}
		
		return nNum;
	}

	virtual int RemoveFiles(vector<string> &vsFileNames, bool bSource = true)
	{
		ASSERT(!bSource);			///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		int nNum = 0;
		FDFPaths fdfPaths;
		GetFDFPaths(bSource, fdfPaths);

		for (int ii = 0; ii < vsFileNames.GetSize(); ii++)
		{
			string strFile = vsFileNames[ii];
			strFile.Replace(STR_FDF_FILE_EXT, "");
			if ( m_gfo.RemoveFile(strFile, fdfPaths, true) )
				nNum++;
			else
				vsFileNames.RemoveAt(ii--);
		}
		
		return nNum;
	}
	
protected:

	void GetFDFPaths(bool bSource, FDFPaths& fdfPaths)
	{
		if(bSource)
		{
			fdfPaths.strFilePath = m_strSrcPath;
			if(m_bSrcPathSpecified)
			{
				fdfPaths.strIniPath = "";
				fdfPaths.strSysPath = "";
			}
			else
			{
				string strSysPath, strUserPath;
				get_origin_user_path(strSysPath, m_strRegistryKey, false);
				get_origin_user_path(strUserPath, m_strRegistryKey, true);
				fdfPaths.strIniPath = strUserPath;
				fdfPaths.strSysPath = strSysPath;
			}
		}
		else
		{
			fdfPaths.strFilePath = m_strDestPath;
			fdfPaths.strIniPath = okutil_get_origin_path(ORIGIN_PATH_USER);
			fdfPaths.strSysPath = okutil_get_origin_path(ORIGIN_PATH_SYSTEM);
		}
	}
	
private:
	GroupFunctionOrganizer	m_gfo;
};

class OGSTransfer : public FileTransferBase
{
public:
	OGSTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) : FileTransferBase(lpcszRegKey, lpcszSpecifiedPath){}
	
	virtual int GetFiles(bool bSource, vector<string>& vsFiles)
	{ 
		vector<string> vsExt = {".ogs"};
		GetFiles(bSource ? m_strSrcPath : m_strDestPath, vsExt, vsFiles);
		return vsFiles.GetSize();
	}
};


enum
{
	FILE_TYPE_OGW,
	FILE_TYPE_DIALOG_THEME,
	FILE_TYPE_FDF,
	FILE_TYPE_IMPORT_FILTER,
	FILE_TYPE_OGS,
	FILE_TYPE_DATABASE,
	FILE_TYPE_ORIGINC,
	FILE_TYPE_PACKAGE,
	FILE_TYPE_TEMPLATE,
	FILE_TYPE_PATCH,
	FILE_TYPE_PROJECT,
	FILE_TYPE_THEME,
	FILE_TYPE_XF,
	FILE_TYPE_OMC,
	FILE_TYPE_DEFAULT_SETTINGS,
	FILE_TYPE_OTHER_FILE,
	FILE_TYPE_ALL_FILE,
};

#define STR_PROJECT_FILE_EXT			".opj"
#define STR_ANALYSIS_TEMPLATE_EXT		".ogw"
///Kyle 08/02/2010 ORG-692-P1 TRANSFER_USER_FILES_HANDLE_DOCX_FILE
//#define STR_OTHER_FILE_EXT				".doc|.pdf"
#define STR_OTHER_FILE_EXT				".doc|.docx|.pdf"
///End TRANSFER_USER_FILES_HANDLE_DOCX_FILE

#define STR_PACKAGE_80_EXT				".opx"
#define STR_PACKAGE_75_EXT				".opk"
#define STR_PACKAGE_SUB_FOLDER			"Auto Install\\" /// EJP 2007-10-02 v8.0714 QA70-10469 MORE_WORK_FOR_OPX_AND_GROUP_FOLDER

#define STR_DATABASE_FILE_EXT			".ODQ|.ODS"


class AllFilePublish : public FilePublishBase
{
public:	
	AllFilePublish()
	{
		m_pThemeFilePublish = m_pXFFilePublish = NULL;
		vector<int> vnAllFileType = {
			FILE_TYPE_OGW,
			FILE_TYPE_DIALOG_THEME,
			FILE_TYPE_FDF,
			FILE_TYPE_IMPORT_FILTER,
			FILE_TYPE_OGS,
			FILE_TYPE_DATABASE,
			FILE_TYPE_ORIGINC,
			FILE_TYPE_PACKAGE,
			FILE_TYPE_TEMPLATE,
			FILE_TYPE_PATCH,
			FILE_TYPE_PROJECT,
			FILE_TYPE_THEME,
			FILE_TYPE_XF,
			FILE_TYPE_OMC,
			FILE_TYPE_DEFAULT_SETTINGS,
			FILE_TYPE_OTHER_FILE
		};
		m_vnValidFileType = m_vnAllFileType = vnAllFileType;
		
		vector<string> vsAllFileTypeExt = {
			"OGW",
			"OIS",
			"FDF",
			"OIF",
			"OGS",
			"ODQ|ODS",
			"H|C|CPP",
			"OPX|OPK",
			"OTP|OTW|OTM",
			"EXE",
			"OPJ",
			"OTH",
			"OXF",
			MENU_CUSTOMIZATION_FILE_EXT,
			"XML",
			///Kyle 08/02/2010 ORG-692-P1 TRANSFER_USER_FILES_HANDLE_DOCX_FILE
			//"DOC|PDF"
			"DOC|DOCX|PDF"
			///End TRANSFER_USER_FILES_HANDLE_DOCX_FILE
		};
		m_vsAllFileTypeExt = vsAllFileTypeExt;

		if (!okutil_is_group_files_update_feature_permitted())
		{
			m_vnValidFileType.SetSize(0);
			m_vnValidFileType.Add(FILE_TYPE_PATCH);
		}
	}
	
	~AllFilePublish()
	{
		if(m_pThemeFilePublish)
			delete m_pThemeFilePublish;
		if(m_pXFFilePublish)
			delete m_pXFFilePublish;
	}

	virtual int GetRowInfo(string strKey, vector<string> &vsRowInfo, bool bSource)
	{
		string strExt;
		separate_file_name_ext(strKey, NULL, &strExt);
		int nFileType = getEnumIndexFromFileExt(strExt);
		FilePublishBase *pFilePublish = NULL;
		if (getFilePublishDerivation(nFileType, pFilePublish))
		{
			pFilePublish->GetRowInfo(strKey, vsRowInfo, bSource);
			if (nFileType != FILE_TYPE_THEME && nFileType != FILE_TYPE_XF)
				delete pFilePublish;
		}
		vsRowInfo[FB_COL_FILETYPE] 	= nFileType;
		
		return vsRowInfo.GetSize();
	}
	
	virtual int GetShownInfo(vector<bool>& vbShow)
	{
		vbShow.SetSize(FB_COL_NUMS);
		vbShow = false;
		vbShow[FB_COL_FILE] =
		vbShow[FB_COL_FILETYPE] =
		vbShow[FB_COL_FILESIZE] =
		vbShow[FB_COL_FILEDATE] = true;

		return 4;			// shown cols
	}

	
	virtual int GetFiles(bool bSource, vector<string>& vsFiles)
	{
		for (int ii=0; ii<m_vnValidFileType.GetSize(); ii++)
		{
			FilePublishBase *pFilePublish = NULL;
			if (getFilePublishDerivation(m_vnValidFileType[ii], pFilePublish))
			{
				vector<string> vsSubFiles;
				pFilePublish->GetFiles(bSource, vsSubFiles);
				vsFiles.Append(vsSubFiles);
				if (m_vnValidFileType[ii] == FILE_TYPE_THEME)
					m_pThemeFilePublish = pFilePublish;
				else if (m_vnValidFileType[ii] == FILE_TYPE_XF)
					m_pXFFilePublish = pFilePublish;
				else
					delete pFilePublish;
			}
		}
		return true;
	}

	virtual int PublishFiles(vector<string> &vsFileNames, bool bForward = true)
	{
		return fileOperation(vsFileNames, bForward, true);
	}

	virtual int RemoveFiles(vector<string> &vsFileNames, bool bSource)
	{
		return fileOperation(vsFileNames, bSource, false);
	}
	
	virtual bool GetFileFullPath(string &strFile1, string &strFile2)
	{
		string strExt;
		separate_file_name_ext(strFile1, NULL, &strExt);
		FilePublishBase *pFilePublish = NULL;
		if (getFilePublishDerivation(getEnumIndexFromFileExt(strExt), pFilePublish))
		{
			strFile1 = pFilePublish->GetSrcPath() + strFile1;
			strFile2 = pFilePublish->GetDestPath() + strFile2;
		}
		return true;
	}

private:
	
	int getEnumIndexFromFileExt(string strExt)
	{
		for (int ii=0; ii<m_vsAllFileTypeExt.GetSize(); ii++)
		{
			vector<string> vsExts;
			m_vsAllFileTypeExt[ii].GetTokens(vsExts, '|');
			int nIndex;
			if ((nIndex = vsExts.Find(strExt)) >= 0)
				return ii;
		}
		return -1;
	}
	
	bool getFilePublishDerivation(int nIndex, FilePublishBase* &pFilePublish)
	{
		switch (nIndex)
		{
		case FILE_TYPE_TEMPLATE:
			pFilePublish = new TemplatePublish();
			break;

		case FILE_TYPE_IMPORT_FILTER:
			pFilePublish = new ImpFilterPublish();
			break;
			
		case FILE_TYPE_FDF:
			pFilePublish = new FDFPublish();
			break;
			
		case FILE_TYPE_OGS:
			pFilePublish = new OGSPublish();
			break;
			
		case FILE_TYPE_THEME:
			if (m_pThemeFilePublish)
				pFilePublish = m_pThemeFilePublish;
			else
				pFilePublish = new ThemePublish();
			break;
			
		case FILE_TYPE_PROJECT:
			pFilePublish = new ProjectPublish(STR_PROJECT_FILE_EXT);
			break;
			
		case FILE_TYPE_ORIGINC:
			pFilePublish = new OriginCPublish();
			break;

		case FILE_TYPE_DATABASE:
			pFilePublish = new ProjectPublish(STR_DATABASE_FILE_EXT);
			break;

		case FILE_TYPE_XF:
			if (m_pXFFilePublish)
				pFilePublish = m_pXFFilePublish;
			else
				pFilePublish = new XFPublish();
			break;

		case FILE_TYPE_OMC:
			pFilePublish = new OMCPublish();
			break;

		case FILE_TYPE_DEFAULT_SETTINGS:
			pFilePublish = new DefaultSettingsPublish();
			break;

		case FILE_TYPE_PATCH:
			pFilePublish = new PatchPublish();
			break;
			
		case FILE_TYPE_OGW:
			pFilePublish = new ProjectPublish(STR_ANALYSIS_TEMPLATE_EXT);
			break;
			
		case FILE_TYPE_DIALOG_THEME:
			pFilePublish = new DialogThemePublish();
			break;
			
		case FILE_TYPE_OTHER_FILE:
			pFilePublish = new ProjectPublish(STR_OTHER_FILE_EXT);
			break;

		case FILE_TYPE_PACKAGE:
			pFilePublish = new ProjectPublish(STR_PACKAGE_75_EXT + "|" + STR_PACKAGE_80_EXT, STR_PACKAGE_SUB_FOLDER);
			break;

		default:
			break;
		}
		return pFilePublish != NULL;
	}
	
	int fileOperation(vector<string> &vsFileNames, bool bForward = true, bool bPublish = true)
	{
		int nSize = vsFileNames.GetSize();
		bool bSource = bForward;
		for (int ii=nSize-1; ii>=0; ii--)
		{
			string strExt;
			separate_file_name_ext(vsFileNames[ii], NULL, &strExt);
			FilePublishBase *pFilePublish = NULL;
			if (getFilePublishDerivation(getEnumIndexFromFileExt(strExt), pFilePublish))
			{
				vector<string> vsTmpFile;
				vsTmpFile.Add(vsFileNames[ii]);
				if (bPublish)
				{
					if (pFilePublish->PublishFiles(vsTmpFile, bForward) == 0)
						vsFileNames.RemoveAt(ii);
				}
				else
				{
					if (pFilePublish->RemoveFiles(vsTmpFile, bSource) == 0)
						vsFileNames.RemoveAt(ii);
				}
			}
		}
		return vsFileNames.GetSize();
	}
	
private:
	
	FilePublishBase		*m_pThemeFilePublish;
	FilePublishBase		*m_pXFFilePublish;
	vector<int>			m_vnAllFileType;
	vector<int>			m_vnValidFileType;
	vector<string>		m_vsAllFileTypeExt;
	
};

class OriginCTransfer : public FileTransferBase
{
public:

	OriginCTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) : FileTransferBase(lpcszRegKey, lpcszSpecifiedPath)
	{
		if(m_bSrcPathSpecified == false)
			m_strSrcPath += "OriginC\\";
		m_strDestPath += "OriginC\\";
	}

	virtual int GetFiles(bool bSource, vector<string>& vsFiles)
	{
		vector<string> vsExt = {".h", ".c", ".cpp"};
		string strPath;
		if(bSource)
			strPath = m_strSrcPath;
		else
			strPath = m_strDestPath;
		GetFiles(strPath, vsExt, vsFiles);
		return vsFiles.GetSize();
	}
};

class DefaultSettingsTransfer : public FileTransferBase
{
public:
	DefaultSettingsTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) : FileTransferBase(lpcszRegKey, lpcszSpecifiedPath){}

	virtual int GetFiles(bool bSource, vector<string>& vsFiles)
	{
		FindFiles(vsFiles, bSource ? m_strSrcPath : m_strDestPath, "Defaults.xml");
		return vsFiles.GetSize();
	}
};

class OMCTransfer : public FileTransferBase
{
public:
	OMCTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) : FileTransferBase(lpcszRegKey, lpcszSpecifiedPath){}

	virtual int GetFiles(bool bSource, vector<string>& vsFiles)
	{
		vector<string> vsExt = {".omc"};
		string strPath = bSource ? m_strSrcPath : m_strDestPath;
		GetFiles(strPath, vsExt, vsFiles);
		return vsFiles.GetSize();
	}
};

class PatchTransfer : public FileTransferBase
{
public:
	PatchTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) : FileTransferBase(lpcszRegKey, lpcszSpecifiedPath)
	{
		if(m_bSrcPathSpecified == false)
			m_strSrcPath += STR_UPDATE_FOLDER;
		m_strDestPath += STR_UPDATE_FOLDER;
	}

	virtual int GetFiles(bool bSource, vector<string>& vsFiles)
	{
		vector<string> vsExt = {".exe"};
		string strPath = bSource ? m_strSrcPath : m_strDestPath;
		GetFiles(strPath, vsExt, vsFiles);
		return vsFiles.GetSize();
	}
};

class DialogThemeTransfer : public FileTransferBase
{
public:
	
	DialogThemeTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) : FileTransferBase(lpcszRegKey, lpcszSpecifiedPath)
	{
		if(m_bSrcPathSpecified == false)
			m_strSrcPath += STR_DIALOG_THEME_FOLDER;
		m_strDestPath += STR_DIALOG_THEME_FOLDER;
	}

	virtual int GetFiles(bool bSource, vector<string>& vsFiles)
	{
		vector<string> vsExt = {".ois"};
		string strPath;
		strPath = bSource ? m_strSrcPath : m_strDestPath;
		GetFiles(strPath, vsExt, vsFiles);

		int nSize = vsFiles.GetSize();
		for (int ii=nSize-1; ii>=0; ii--)
		{
			string strName, strTool, strScope, strCategory;
			theme_filename_to_options(vsFiles[ii], strName, strTool, strScope ,strCategory);
			if (is_theme_last_used(GetFileName(strName, true)))
				vsFiles.RemoveAt(ii);
		}

		return vsFiles.GetSize();
	}

};


class ProjectTransfer : public FileTransferBase
{
public:
	ProjectTransfer(string strFileExt, LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath, LPCSTR lpcszSubPath = NULL) : FileTransferBase(lpcszRegKey, lpcszSpecifiedPath)
	{
		if(lpcszSubPath)
		{
			if(m_bSrcPathSpecified == false)
			{
				m_strSrcPath += lpcszSubPath;
				m_strSrcPath.TrimRight("\\");
				m_strSrcPath += "\\";
			}
			m_strDestPath += lpcszSubPath;
			m_strDestPath.TrimRight("\\");
			m_strDestPath += "\\";
		}

		m_strFileExt = strFileExt;
	}

	virtual int GetFiles(bool bSource, vector<string>& vsFiles)
	{
		vector<string> vsExt;
		m_strFileExt.GetTokens(vsExt, '|');
		string strPath;
		if(bSource)
			strPath = m_strSrcPath;
		else
			strPath = m_strDestPath;
		GetFiles(strPath, vsExt, vsFiles);
		return vsFiles.GetSize();
	}

private:
	string m_strFileExt;
};

class AllFileTransfer : public FileTransferBase
{
public:	
	AllFileTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) : FileTransferBase(lpcszRegKey, lpcszSpecifiedPath)
	{
		m_pThemeFileTransfer = new ThemeTransfer(m_strRegistryKey, m_strSpecifiedPath);
		m_pXFFileTransfer = new XFTransfer(m_strRegistryKey, m_strSpecifiedPath);
		vector<int> vnAllFileType = {
			FILE_TYPE_OGW,
			FILE_TYPE_DIALOG_THEME,
			FILE_TYPE_FDF,
			FILE_TYPE_IMPORT_FILTER,
			FILE_TYPE_OGS,
			FILE_TYPE_DATABASE,
			FILE_TYPE_ORIGINC,
			FILE_TYPE_PACKAGE,
			FILE_TYPE_TEMPLATE,
			FILE_TYPE_PATCH,
			FILE_TYPE_PROJECT,
			FILE_TYPE_THEME,
			FILE_TYPE_XF,
			FILE_TYPE_OMC,
			FILE_TYPE_DEFAULT_SETTINGS,
			FILE_TYPE_OTHER_FILE
		};
		m_vnValidFileType = vnAllFileType;
		vector<string> vsAllFileTypeExt = {
			"OGW",
			"OIS",
			"FDF",
			"OIF",
			"OGS",
			"ODQ|ODS",
			"H|C|CPP",
			"OPX|OPK",
			"OTP|OTW|OTM",
			"EXE",
			"OPJ",
			"OTH",
			"OXF",
			MENU_CUSTOMIZATION_FILE_EXT,
			"XML",
			///Kyle 08/02/2010 ORG-692-P1 TRANSFER_USER_FILES_HANDLE_DOCX_FILE
			//"DOC|PDF"
			"DOC|DOCX|PDF"
			///End TRANSFER_USER_FILES_HANDLE_DOCX_FILE
		};
		m_vsAllFileTypeExt = vsAllFileTypeExt;
	}
	
	~AllFileTransfer()
	{
		if(m_pThemeFileTransfer)
			delete m_pThemeFileTransfer;
		if(m_pXFFileTransfer)
			delete m_pXFFileTransfer;
	}

	virtual int GetRowInfo(string strKey, vector<string> &vsRowInfo, bool bSource)
	{
		string strExt;
		separate_file_name_ext(strKey, NULL, &strExt);
		int nFileType = getEnumIndexFromFileExt(strExt);
		FilePublishBase *pFilePublish = NULL;
		if (getFileTransferDerivation(nFileType, pFilePublish))
		{
			pFilePublish->GetRowInfo(strKey, vsRowInfo, bSource);
			if (nFileType != FILE_TYPE_THEME && nFileType != FILE_TYPE_XF)
				delete pFilePublish;
		}
		vsRowInfo[FB_COL_FILETYPE] = nFileType;

		return vsRowInfo.GetSize();
	}
	
	virtual int GetShownInfo(vector<bool>& vbShow)
	{
		vbShow.SetSize(FB_COL_NUMS);
		vbShow = false;
		vbShow[FB_COL_FILE] =
		vbShow[FB_COL_FILETYPE] =
		vbShow[FB_COL_FILESIZE] =
		vbShow[FB_COL_FILEDATE] = true;

		return 4;		// shown cols
	}

	virtual int GetFiles(bool bSource, vector<string>& vsFiles)
	{
		for (int ii=0; ii<m_vnValidFileType.GetSize(); ii++)
		{
			FilePublishBase *pFilePublish = NULL;
			if (getFileTransferDerivation(m_vnValidFileType[ii], pFilePublish))
			{
				vector<string> vsSubFiles;
				pFilePublish->GetFiles(bSource, vsSubFiles);
				vsFiles.Append(vsSubFiles);
				checkRemoveTransferDerivation(pFilePublish);
			}
		}
		return true;
	}

	virtual int PublishFiles(vector<string> &vsFileNames, bool bForward = true)
	{
		return fileOperation(vsFileNames, bForward, true);
	}

	virtual int RemoveFiles(vector<string> &vsFileNames, bool bSource)
	{
		return fileOperation(vsFileNames, bSource, false);
	}
	
	virtual bool GetFileFullPath(string &strFile1, string &strFile2)
	{
		string strExt;
		separate_file_name_ext(strFile1, NULL, &strExt);
		FilePublishBase *pFilePublish = NULL;
		int nFileType = getEnumIndexFromFileExt(strExt);
		if (getFileTransferDerivation(nFileType, pFilePublish))
		{
			pFilePublish->GetFileFullPath(strFile1, strFile2);
			checkRemoveTransferDerivation(pFilePublish);
		}
		return true;
	}

	// for theme transfer only
	virtual int	GetAvailableCates(vector<string>& vsCategories)
	{
		ASSERT(m_pThemeFileTransfer);
		return m_pThemeFileTransfer->GetAvailableCates(vsCategories);
	}
	
	virtual void SetDestCategory(LPCSTR lpcszCategory)
	{
		ASSERT(m_pThemeFileTransfer);
		m_pThemeFileTransfer->SetDestCategory(lpcszCategory);
	}
	
	virtual string GetDestCategory(LPCSTR lpcszFile = NULL)
	{
		string strExt;
		separate_file_name_ext(lpcszFile, NULL, &strExt);
		FilePublishBase *pFilePublish = NULL;
		string strCategory;
		if (getFileTransferDerivation(getEnumIndexFromFileExt(strExt), pFilePublish))
		{
			strCategory = pFilePublish->GetDestCategory();
			checkRemoveTransferDerivation(pFilePublish);
		}
		return strCategory;
	}

private:

	int getEnumIndexFromFileExt(string strExt)
	{
		for (int ii=0; ii<m_vsAllFileTypeExt.GetSize(); ii++)
		{
			vector<string> vsExts;
			m_vsAllFileTypeExt[ii].GetTokens(vsExts, '|');
			int nIndex;
			if ((nIndex = vsExts.Find(strExt)) >= 0)
				return ii;
		}
		return -1;
	}
	
	bool getFileTransferDerivation(int nIndex, FilePublishBase* &pFileTransfer)
	{
		switch (nIndex)
		{
		case FILE_TYPE_TEMPLATE:
			pFileTransfer = new TemplateTransfer(m_strRegistryKey, m_strSpecifiedPath);
			break;

		case FILE_TYPE_IMPORT_FILTER:
			pFileTransfer = new ImpFilterTransfer(m_strRegistryKey, m_strSpecifiedPath);
			break;
			
		case FILE_TYPE_FDF:
			pFileTransfer = new FDFTransfer(m_strRegistryKey, m_strSpecifiedPath);
			break;
			
		case FILE_TYPE_OGS:
			pFileTransfer = new OGSTransfer(m_strRegistryKey, m_strSpecifiedPath);
			break;
			
		case FILE_TYPE_THEME:
			ASSERT(m_pThemeFileTransfer);
			pFileTransfer = m_pThemeFileTransfer;
			break;
			
		case FILE_TYPE_PROJECT:
			pFileTransfer = new ProjectTransfer(STR_PROJECT_FILE_EXT, m_strRegistryKey, m_strSpecifiedPath);
			break;
			
		case FILE_TYPE_ORIGINC:
			pFileTransfer = new OriginCTransfer(m_strRegistryKey, m_strSpecifiedPath);
			break;

		case FILE_TYPE_DATABASE:
			pFileTransfer = new ProjectTransfer(STR_DATABASE_FILE_EXT, m_strRegistryKey, m_strSpecifiedPath);
			break;

		case FILE_TYPE_XF:
			ASSERT(m_pXFFileTransfer);
			pFileTransfer = m_pXFFileTransfer;
			break;

		case FILE_TYPE_OMC:
			pFileTransfer = new OMCTransfer(m_strRegistryKey, m_strSpecifiedPath);
			break;

		case FILE_TYPE_DEFAULT_SETTINGS:
			pFileTransfer = new DefaultSettingsTransfer(m_strRegistryKey, m_strSpecifiedPath);
			break;

		case FILE_TYPE_PATCH:
			pFileTransfer = new PatchTransfer(m_strRegistryKey, m_strSpecifiedPath);
			break;
			
		case FILE_TYPE_OGW:
			pFileTransfer = new ProjectTransfer(STR_ANALYSIS_TEMPLATE_EXT, m_strRegistryKey, m_strSpecifiedPath);
			break;
			
		case FILE_TYPE_DIALOG_THEME:
			pFileTransfer = new DialogThemeTransfer(m_strRegistryKey, m_strSpecifiedPath);
			break;
			
		case FILE_TYPE_OTHER_FILE:
			pFileTransfer = new ProjectTransfer(STR_OTHER_FILE_EXT, m_strRegistryKey, m_strSpecifiedPath);
			break;

		case FILE_TYPE_PACKAGE:
			pFileTransfer = new ProjectTransfer(STR_PACKAGE_75_EXT + "|" + STR_PACKAGE_80_EXT, STR_PACKAGE_SUB_FOLDER, m_strRegistryKey, m_strSpecifiedPath);
			break;

		default:
			break;
		}
		return pFileTransfer != NULL;
	}
	
	void checkRemoveTransferDerivation(FileTransferBase* pFileTransfer)
	{
		if(pFileTransfer && pFileTransfer != m_pThemeFileTransfer && pFileTransfer != m_pXFFileTransfer)
			delete pFileTransfer;
	}

	int fileOperation(vector<string> &vsFileNames, bool bForward = true, bool bPublish = true)
	{
		int nSize = vsFileNames.GetSize();
		bool bSource = bForward;
		for (int ii=nSize-1; ii>=0; ii--)
		{
			string strExt;
			separate_file_name_ext(vsFileNames[ii], NULL, &strExt);
			FilePublishBase *pFilePublish = NULL;
			int nFileType = getEnumIndexFromFileExt(strExt);
			if (getFileTransferDerivation(nFileType, pFilePublish))
			{
				vector<string> vsTmpFile;
				vsTmpFile.Add(vsFileNames[ii]);
				if (bPublish)
				{
					if (pFilePublish->PublishFiles(vsTmpFile, bForward) == 0)
						vsFileNames.RemoveAt(ii);
				}
				else
				{
					if (pFilePublish->RemoveFiles(vsTmpFile, bSource) == 0)
						vsFileNames.RemoveAt(ii);
				}
				
				checkRemoveTransferDerivation(pFilePublish);
			}
		}
		return vsFileNames.GetSize();
	}	
private:
	// need to keep some info
	FileTransferBase	*m_pThemeFileTransfer;
	FileTransferBase	*m_pXFFileTransfer;

	vector<int>			m_vnValidFileType;
	vector<string>		m_vsAllFileTypeExt;
};

//////////////////////////////////////////////////////////////////////////////// end of new code /////////////////////////////////////////////////////////////////

#else // _OLD_GROUP_FOLDER_MANAGER_AND_TRANSFER_USER_FILES_
///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL

#define SUPPORT_PACKAGE_FILES		//------ Folger 09/28/07 SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION

//#define STR_SECTION	"UpdateInfo"
//#define STR_VERSION	"version"

//#define ORIGIN_PATH_USER75		-2		//------ Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80

//#define SAVE_PARTITIAL_GROUP_PATH_USING_XML_TREE		//------ Folger 08/29/07 SAVE_PARTITIAL_GROUP_PATH_FOR_PUBLISH

/// Hong 08/20/07 v8.0685 CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR
#include "NumFunctionOrganizer.h"


class GroupFunctionOrganizer : public NumFunctionOrganizer
{
public:
	
	//------ Folger 09/03/07 SUPPORT_GET_ORIGIN75_PATH_IN_FILE_PUBLISH
	string GetFunctionFolder(int nPath, string strSubFolder)
	{
		if (nPath == ORIGIN_PATH_USER75)
		{
			string strPath;
			if (get_origin75_user_path(strPath))
			{
				strPath += STR_FDF_FILE_FOLDER_BACKSLASH;
				strPath += strSubFolder;
			}
			return strPath;
		}
		return NumFunctionOrganizer::GetFunctionFolder(nPath, strSubFolder);
	}
	//------ End SUPPORT_GET_ORIGIN75_PATH_IN_FILE_PUBLISH
	
	//------ Folger 08/30/07 MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
	//int	GetCategoryList(vector<string> &vsCategorys, bool bGroupFolder = true)
	int	GetCategoryList(vector<string> &vsCategorys, bool bGroupFolder = true, bool bGroupMgr = true)
	//------ End MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
	{
		//------ Folger 08/30/07 MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
		//int nPath = bGroupFolder ? ALL_USER_FOLDER : USER_FOLDER;
		int nPath = getOriginPath(bGroupFolder, bGroupMgr);
		//------ End MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
		
		nlf_get_section_keys_and_values(STR_NODE_CATEGORY, vsCategorys, NULL, NULL, nPath );
		
		return vsCategorys.GetSize();
	}
	
	//------ Folger 08/30/07 MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
	//int	GetFunctionList(vector<string> &vsFunctions, vector<string> &vsFunctionFullFileNames, LPCSTR lpcstrCategoryName , bool bGroupFolder = true)
	int	GetFunctionList(vector<string> &vsFunctions, vector<string> &vsFunctionFullFileNames, LPCSTR lpcstrCategoryName , bool bGroupFolder = true, bool bGroupMgr = true)
	//------ End MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
	{
		vsFunctions.SetSize(0);
		vsFunctionFullFileNames.SetSize(0);

		//------ Folger 08/30/07 MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
		//int nPath = bGroupFolder ? ALL_USER_FOLDER : USER_FOLDER;
		int nPath = getOriginPath(bGroupFolder, bGroupMgr);
		//------ End MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
		
		//------ Folger 11/27/07 EXCLUDE_DEFAULT_FUNCTION_IN_GRID
		//nlf_get_section_keys_and_values(lpcstrCategoryName, vsFunctions, vsFunctionFullFileNames, NULL, nPath);
		int nDefaultFunc = 0;
		nlf_get_section_keys_and_values(lpcstrCategoryName, vsFunctions, vsFunctionFullFileNames, &nDefaultFunc, nPath);
		//------

		/// Hong 08/22/07 v8.0687 REMOVE_FILE_NOT_EXIST_IN_ACCORDING_FOLDER		
		string strFunctionFullPath;
		for (int ii = vsFunctionFullFileNames.GetSize() - 1; ii >= 0; ii--)
		{
			 strFunctionFullPath = GetFunctionFileFullPath(vsFunctionFullFileNames[ii], nPath);
			 if ( !strFunctionFullPath.IsFile() )
			 {
			 	vsFunctionFullFileNames.RemoveAt(ii);
			 	vsFunctions.RemoveAt(ii);
			 }
		}
		/// end REMOVE_FILE_NOT_EXIST_IN_ACCORDING_FOLDER		
		return vsFunctions.GetSize();
	}
	
	//------ Folger 08/30/07 MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
	//int GetFilesList(vector<string> &vsFunctions, vector<string> &vsFunctionFullFileNames, bool bGroupFolder = true)
	int GetFilesList(vector<string> &vsFunctions, vector<string> &vsFunctionFullFileNames, bool bGroupFolder = true, bool bGroupMgr = true)
	//------ End MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
	{
		vector<string> vsCategoties;
		//------ Folger 08/30/07 MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
		//GetCategoryList(vsCategoties, bGroupFolder);
		GetCategoryList(vsCategoties, bGroupFolder, bGroupMgr);
		//------ End MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
		
		for (int ii = 0; ii < vsCategoties.GetSize(); ii++)
		{			
			vector<string> vsFuncTemp, vsFuncFNamesTemp;
			//------ Folger 08/30/07 MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
			//if ( GetFunctionList(vsFuncTemp, vsFuncFNamesTemp, vsCategoties[ii], bGroupFolder) > 0 )
			if ( GetFunctionList(vsFuncTemp, vsFuncFNamesTemp, vsCategoties[ii], bGroupFolder, bGroupMgr) > 0 )
			//------ End MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
			{
				vsFunctions.Append(vsFuncTemp);
				vsFunctionFullFileNames.Append(vsFuncFNamesTemp);
			}			
		}		
		return vsFunctions.GetSize();
	}
	
	//------ Folger 08/30/07 MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
	//bool AddFile(LPCSTR lpcszName, bool bFromUserToGroupFolder = true)
	bool AddFile(LPCSTR lpcszName, bool bFromUserToGroupFolder = true, bool bGroupMgr = true)
	//------ End MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
	{
		/// Hong 08/22/07 IMPROVE_CODE
		/*
		string strUserPath = okutil_get_origin_path(ORIGIN_PATH_USER, NULL, TRUE) + STR_FDF_FILE_FOLDER;
		string strGroupPath = okutil_get_origin_path(ORIGIN_PATH_GROUP, NULL, TRUE) + STR_FDF_FILE_FOLDER;
		if ( bFromUserToGroupFolder )
		{
			CopyFile(strUserPath + lpcszName, strGroupPath + lpcszName);
		}
		else
			Add(NULL, strGroupPath + lpcszName, lpcszName);
		
		string strCategory = GetCategory(lpcszName, !bFromUserToGroupFolder);
		
		int nPath = bFromUserToGroupFolder ? ALL_USER_FOLDER : USER_FOLDER;
		UpdateFunctionToNLSF(strCategory, lpcszName, NULL, lpcszName, nPath);
		*/
		
		//------ Folger 08/30/07 MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
		//string strUserFilePath = GetFunctionFileFullPath(lpcszName, USER_FOLDER); 
		//string strGroupFilePath = GetFunctionFileFullPath(lpcszName, ALL_USER_FOLDER);
		string strUserFilePath, strGroupFilePath;
		//--- CPY 9/1/2007 CLEAN_UP_CODE_RELATED_TO_GETTING_75_FDF_FILES
		/*
		if (bGroupMgr)
		{
			strUserFilePath = GetFunctionFileFullPath(lpcszName, USER_FOLDER); 
			strGroupFilePath = GetFunctionFileFullPath(lpcszName, ALL_USER_FOLDER);
		}
		else
		{
			strUserFilePath = GetFunctionFileFullPath(lpcszName, ORIGIN_PATH_USER_PREV_VER); 
			strGroupFilePath = GetFunctionFileFullPath(lpcszName, USER_FOLDER);

		}
		*/
		if(!getFunctionFileSourceDestination(lpcszName, strUserFilePath, strGroupFilePath, bGroupMgr))
			return false;
		//--- end CLEAN_UP_CODE_RELATED_TO_GETTING_75_FDF_FILES
		//------ End MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
		
		string strDLLFile;		//------ Folger 01/14/08 NEED_TO_MANIPULATE_DLL_FILE_WITH_EXTERNAL_DLL_FDF
		
		if ( bFromUserToGroupFolder )
		{
			CheckMakePath(GetFilePath(strGroupFilePath));
			//------ Folger 09/27/07 RESET_ATTRIBUTE_WHEN_COPY_FILE
			//if (!CopyFile(strUserFilePath, strGroupFilePath))
			if (copyfile(strUserFilePath, strGroupFilePath, 0))
			//------ End /07 RESET_ATTRIBUTE_WHEN_COPY_FILE
				return false;
			//------ Folger 01/14/08 NEED_TO_MANIPULATE_DLL_FILE_WITH_EXTERNAL_DLL_FDF
			if ( checkGetDLLFileName(strUserFilePath, strDLLFile, bGroupMgr) )
				copyfile(strDLLFile, GetFilePath(strGroupFilePath) + GetFileName(strDLLFile));
			//------
		}
		else
			//------ Folger 08/30/07 FIX_BUGS_WHEN_MOVE_FILES_FROM_GROUP_TO_USER
			//Add(NULL, strGroupFilePath, lpcszName);
		{
			CheckMakePath(GetFilePath(strGroupFilePath));
			//------ Folger 09/27/07 RESET_ATTRIBUTE_WHEN_COPY_FILE
			//if (!CopyFile(strGroupFilePath, strUserFilePath))
			if (copyfile(strGroupFilePath, strUserFilePath, 0))
			//------ End RESET_ATTRIBUTE_WHEN_COPY_FILE	
				return false;
			//------ Folger 01/14/08 NEED_TO_MANIPULATE_DLL_FILE_WITH_EXTERNAL_DLL_FDF
			if ( checkGetDLLFileName(strGroupFilePath, strDLLFile, bGroupMgr) )
				copyfile(strDLLFile, GetFilePath(strUserFilePath) + GetFileName(strDLLFile));
			//------
		}
			//------ End FIX_BUGS_WHEN_MOVE_FILES_FROM_GROUP_TO_USER
		
		//------ Folger 08/30/07 MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
		//int nPath = bFromUserToGroupFolder ? ALL_USER_FOLDER : USER_FOLDER;
		int nPath = getOriginPath(bFromUserToGroupFolder, bGroupMgr);
		//------ End MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
		
		vector<string> vsCategories;
		//------ Folger 09/05/07 CLEAN_UP_FDF_MODIFICATION_CODES
		//GetCategories(lpcszName, vsCategories, !bFromUserToGroupFolder, bGroupMgr);
		string strFunction;
		GetCategories(lpcszName, strFunction, vsCategories, !bFromUserToGroupFolder, bGroupMgr);
		//------ End CLEAN_UP_FDF_MODIFICATION_CODES
		
		for (int ii = 0; ii < vsCategories.GetSize(); ii++)
		{
			UpdateCategoryToNLSF(vsCategories[ii], NULL, nPath);
			//------ Folger 09/05/07 CLEAN_UP_FDF_MODIFICATION_CODES
			//UpdateFunctionToNLSF(vsCategories[ii], lpcszName, NULL, lpcszName, nPath);
			UpdateFunctionToNLSF(vsCategories[ii], strFunction, NULL, lpcszName, nPath);
			//------ End CLEAN_UP_FDF_MODIFICATION_CODES
		}
		/// end IMPROVE_CODE
		return true;
	}
	//------ Folger 08/30/07 MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
	//bool RemoveFile(LPCSTR lpcszName, bool bGroupFolder = true)
	bool RemoveFile(LPCSTR lpcszName, bool bGroupFolder = true, bool bGroupMgr = true)
	//------ End MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
	{
		//------ Folger 08/30/07 MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
		//int nPath = bFromUserToGroupFolder ? ALL_USER_FOLDER : USER_FOLDER;
		int nPath = getOriginPath(bGroupFolder, bGroupMgr);
		//------ End MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
		
		/// Hong 08/22/07 IMPROVE_CODE
		/*
		string strPath = okutil_get_origin_path(nPath, NULL, TRUE) + STR_FDF_FILE_FOLDER;	
		DeleteFile(strPath + lpcszName);
		
		string strCategory = GetCategory(lpcszName, bGroupFolder);
		UpdateFunctionToNLSF(strCategory, NULL, lpcszName, lpcszName, nPath);
		*/
		vector<string> vsCategories;		
		//------ Folger 09/05/07 CLEAN_UP_FDF_MODIFICATION_CODES
		//GetCategories(lpcszName, vsCategories, bGroupFolder, bGroupMgr);
		string strFunction;
		GetCategories(lpcszName, strFunction, vsCategories, bGroupFolder, bGroupMgr);
		//------ End CLEAN_UP_FDF_MODIFICATION_CODES
		
		for (int ii = 0; ii < vsCategories.GetSize(); ii++)
		{
			//------ Folger 09/05/07 CLEAN_UP_FDF_MODIFICATION_CODES
			//UpdateFunctionToNLSF(vsCategories[ii], NULL, lpcszName, lpcszName, nPath);
			UpdateFunctionToNLSF(vsCategories[ii], NULL, strFunction, lpcszName, nPath);
			//------ End CLEAN_UP_FDF_MODIFICATION_CODES
		}
		
		string strFilePath = GetFunctionFileFullPath(lpcszName, nPath);
		//------ Folger 01/14/08 NEED_TO_MANIPULATE_DLL_FILE_WITH_EXTERNAL_DLL_FDF
		string strDLLFile;
		checkGetDLLFileName(strFilePath, strDLLFile, bGroupMgr, false);
		//------
		
		//------ Folger 08/30/07 MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
		//if ( !bGroupFolder )
		if ( !bGroupFolder || !bGroupMgr)
		//------ End MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
		{	// following code copy from base class, later may need to do centralization			
			string	strDeletePath = GetFunctionFolder(nPath, STR_FDF_DELETE_FILE_FOLDER);
	
			if( CheckMakePath( strDeletePath ) )
			{			
				strDeletePath = GetFunctionFileFullPath(lpcszName, nPath, STR_FDF_DELETE_FILE_FOLDER);				
				//------ Folger 09/27/07 RESET_ATTRIBUTE_WHEN_COPY_FILE
				//CopyFile(strFilePath, strDeletePath);
				copyfile(strFilePath, strDeletePath, 0);
				//------ End RESET_ATTRIBUTE_WHEN_COPY_FILE
				//------ Folger 01/14/08 NEED_TO_MANIPULATE_DLL_FILE_WITH_EXTERNAL_DLL_FDF
				copyfile(strDLLFile, GetFilePath(strDeletePath) + GetFileName(strDLLFile));
				//------
			}
		}
		//------ Folger 09/27/07 DELETE_FILE_REGARDLESS_OF_READ_ONLY
		//DeleteFile(strFilePath);
		if (!okutil_delete_file(strFilePath, true))
			return false;
		//------ End DELETE_FILE_REGARDLESS_OF_READ_ONLY
		/// end IMPROVE_CODE		
		
		//------ Folger 01/14/08 NEED_TO_MANIPULATE_DLL_FILE_WITH_EXTERNAL_DLL_FDF
		okutil_delete_file(strDLLFile, true);
		//------
		
		return true;
	}
	/// Hong 08/22/07 IMPROVE_CODE
	/*
	string GetCategory(LPCSTR lpcszFileName, bool bGroupFolder = true)
	{
		vector<string> vsCategoties;
		GetCategoryList(vsCategoties, bGroupFolder);
		for (int ii = 0; ii < vsCategoties.GetSize(); ii++)
		{
			vector<string> vsFunctions, vsFunctionFullFileNames;
			GetFunctionList(vsFunctions, vsFunctionFullFileNames, vsCategoties[ii], bGroupFolder);
			if ( vsFunctions.Find(lpcszFileName) > -1 )
				return vsCategoties[ii];	
		}
		return "";
	}
	*/
	//int GetCategories(LPCSTR lpcszFileName, vector<string>& vsCategories, bool bGroupFolder = true, bool bGroupMgr = true)
	int GetCategories(LPCSTR lpcszFileName, string &strFunction, vector<string>& vsCategories, bool bGroupFolder = true, bool bGroupMgr = true)
	{
		vsCategories.RemoveAll();
		GetCategoryList(vsCategories, bGroupFolder, bGroupMgr);
		for (int ii = vsCategories.GetSize() - 1; ii >= 0; ii--)
		{
			vector<string> vsFunctions, vsFunctionFullFileNames;
			GetFunctionList(vsFunctions, vsFunctionFullFileNames, vsCategories[ii], bGroupFolder, bGroupMgr);
			//------ Folger 09/04/07 GET_NLFIT_FILE_NAME_INSTEAD_OF_FUNCTION_NAME
			//if ( -1 == vsFunctions.Find(lpcszFileName) )
			//------ Folger 09/05/07 CLEAN_UP_FDF_MODIFICATION_CODES
			//if ( -1 == vsFunctionFullFileNames.Find(lpcszFileName) )
			////------ End GET_NLFIT_FILE_NAME_INSTEAD_OF_FUNCTION_NAME
				//vsCategories.RemoveAt(ii);
			int nIndex = vsFunctionFullFileNames.Find(lpcszFileName);
			if (nIndex < 0)
				vsCategories.RemoveAt(ii);
			else
			{
				if (strFunction.IsEmpty())
					strFunction = vsFunctions[nIndex];
			}
			//------ End CLEAN_UP_FDF_MODIFICATION_CODES
		}
		
		return vsCategories.GetSize();
	}
	/// end IMPROVE_CODE
	
//------ Folger 08/30/07 MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80	
private:
	bool getFunctionFileSourceDestination(LPCSTR lpcszName, string& strUserFilePath, string& strGroupFilePath, bool bGroupMgr)
	{ 
		if (bGroupMgr)
		{
			strUserFilePath = GetFunctionFileFullPath(lpcszName, USER_FOLDER); 
			strGroupFilePath = GetFunctionFileFullPath(lpcszName, ORIGIN_PATH_SERVER_GROUP_FOLDER);
		}
		else
		{
			//strUserFilePath = GetFunctionFileFullPath(lpcszName, ORIGIN_PATH_USER_PREV_VER);
			//------ Folger 09/03/07 SUPPORT_GET_ORIGIN75_PATH_IN_FILE_PUBLISH
			//if(!get_origin75_user_path(strUserFilePath))
				//return false;
			strUserFilePath = GetFunctionFileFullPath(lpcszName, ORIGIN_PATH_USER75);
			//------ End SUPPORT_GET_ORIGIN75_PATH_IN_FILE_PUBLISH
			strGroupFilePath = GetFunctionFileFullPath(lpcszName, USER_FOLDER);
		}
		return true;
	}
	
	int getOriginPath(bool bGroupFolder, bool bGroupMgr)
	{
		int nPath;
		if (bGroupMgr)
			nPath = bGroupFolder ? ORIGIN_PATH_SERVER_GROUP_FOLDER : USER_FOLDER;
		else
			//------ CPY 9/1/2007 CLEAN_UP_CODE_RELATED_TO_GETTING_75_FDF_FILES
			//nPath = bGroupFolder ? USER_FOLDER : ORIGIN_PATH_USER_PREV_VER;
			nPath = bGroupFolder ? USER_FOLDER : ORIGIN_PATH_USER75;
			//------
		return nPath;
	}
//------ End MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80

	//------ Folger 01/14/08 NEED_TO_MANIPULATE_DLL_FILE_WITH_EXTERNAL_DLL_FDF
	bool	checkGetDLLFileName(LPCSTR lpcszName, string &strDLLFile, bool bGroupMgr = true, bool bCopy = true)
	{
		INIFile fdf(lpcszName, false);
		string strFuncType = fdf.ReadString(STR_FUNC_GENERAL_INFO, STR_FUNC_TYPE);
		if ( strFuncType.CompareNoCase(STR_FUNCTION_TYPE_EXTERN_DLL) != 0 )
			return false;
		
		string strFile = fdf.ReadString(STR_FUNC_GENERAL_INFO, STR_FUNCTION_SOURCE);
		//------ Folger 01/31/08 QA80-10933 FIX_BUG_OF_DLL_FILE_NAME_CONVENTION
		vector<string> vsTmp;
		strFile.GetTokens(vsTmp, '.');
		strFile = vsTmp[0];
		//------
		LPSTR lpszDLLFile = strFile.GetBuffer(MAXLINE);
		check_add_file_ext(lpszDLLFile, STR_FUNCTION_DLL_SOURCE);
		strFile.ReleaseBuffer();
		strDLLFile = GetFilePath(lpcszName) + strFile;
		if ( !strDLLFile.IsFile() )
		{
			if ( !bCopy )
				return false;
			if ( bGroupMgr )
				strDLLFile = okutil_get_origin_path(ORIGIN_PATH_SYSTEM);
			else
				get_origin75_user_path(strDLLFile, false);
			strDLLFile += strFile;
			if ( !strDLLFile.IsFile() )
				return false;
		}
		
		return true;
	}
	//------
};
/// end CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR

class FilePublishBase
{
public:
	virtual int GetFiles(int nPath, vector<string>& vsFiles){ return -1;}
	
	//------ Folger 09/03/07 SUPPORT_MORE_FILE_TYPES
	////------ Folger 08/21/07 CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR
	////virtual int PublishFiles(const vector<string> vsFileNames)
	//virtual int PublishFiles(vector<string> &vsFileNames, bool bFromuserToGroupFolder = true, bool bGroupMgr = true)
	////------ End CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR
	//{
		////------ Folger 08/21/07 CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR
		////int nFileCopied = CopyFiles(vsFileNames);
		//// update version	
		////if ( nFileCopied > 0 )
		////------ End CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR
		//if (bFromuserToGroupFolder)
		//{
			//INIFile iniFile(okutil_get_origin_path(ORIGIN_PATH_GROUP) + "update.ini");
			//int nVersion;
			//nVersion = iniFile.ReadInt(STR_SECTION, STR_VERSION, 0);	
			//nVersion++;
			//iniFile.WriteInt(STR_SECTION, STR_VERSION, nVersion);
		//}
		////------ Folger 08/21/07 CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR
		////return nFileCopied;
		//return 0;
		////------ End CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR
	//}
	////------ Folger 08/21/07 CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR
	//virtual int RemoveFiles(vector<string> &vsFileNames, bool bGroupFolder = true)
	//{
		//return 0;
	//}
	////------ End CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR
	virtual int PublishFiles(vector<string> &vsFileNames, bool bFromuserToGroupFolder = true, bool bGroupMgr = true)
	{
		int nSize = vsFileNames.GetSize();
		vector<string> vsFileFullNames(nSize);
		string strPath = bFromuserToGroupFolder ? m_strUserPath : m_strGroupPath;
		for (int ii=0; ii<nSize; ii++)
		{
			vsFileFullNames[ii] = strPath + vsFileNames[ii];
		}
		
		int nRet = CopyFiles(vsFileFullNames, bFromuserToGroupFolder, bGroupMgr);
		if (nRet != nSize)
		{
			for (ii=nSize-1; ii>=0; ii--)
			{
				if (vsFileFullNames[ii].IsEmpty())
					vsFileNames.RemoveAt(ii);
			}
		}
		return nRet;
	}
	
	virtual int RemoveFiles(vector<string> &vsFileNames, bool bGroupFolder = true)
	{
		int nSize = vsFileNames.GetSize();
		string strPath = bGroupFolder ? m_strGroupPath : m_strUserPath;
		for (int ii=nSize-1; ii>=0; ii--)
		{
			//------ Folger 09/27/07 DELETE_FILE_REGARDLESS_OF_READ_ONLY
			//if (!DeleteFile(strPath + vsFileNames[ii]))
			if (!okutil_delete_file(strPath + vsFileNames[ii], true))
			//------ End DELETE_FILE_REGARDLESS_OF_READ_ONLY
				vsFileNames.RemoveAt(ii);
		}
		return vsFileNames.GetSize();
	}
	//------ End SUPPORT_MORE_FILE_TYPES
	
	//------ Folger 08/24/07 GET_COL_HEADING_BY_FILE_PATH
	//virtual int GetColNames(vector<string> &vsColNames)
	//{
		//vsColNames.Add("Files");
		//return vsColNames.GetSize();
	//}
	virtual int GetColNames(vector<string> &vsColNames,int nPath)
	{
		string strFile;
		switch (nPath)
		{
		case ORIGIN_PATH_USER:
			strFile = _L("User Files");
			break;
		//------ CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH
		//case ORIGIN_PATH_GROUP:
		case ORIGIN_PATH_SERVER_GROUP_FOLDER:
		//------
			strFile = _L("Group Files");
			break;
		//------ Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80
		case ORIGIN_PATH_USER75:
			strFile = _L("7.5 User Files");
			break;
		//------ End SUPPORT_TRANSFER_FILES_FROM_75_TO_80
		default:
			break;
		}
		vsColNames.Add(strFile);
		return vsColNames.GetSize();
	}
	//------ End GET_COL_HEADING_BY_FILE_PATH
	
	virtual int GetRowInfo(string strKey, vector<string> &vsRowInfo, int nPath)
	{
		vsRowInfo.Add(strKey);
		return vsRowInfo.GetSize();
	}
	//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
	virtual bool GetFileFullPath(string &strFile1, string &strFile2)
	{
		strFile1 = m_strUserPath + strFile1;
		strFile2 = m_strGroupPath + strFile2;
		return true;
	}
	//------ End SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
	string GetUserPath()
	{
		return m_strUserPath;
	}
	string GetGroupPath()
	{
		return m_strGroupPath;
	}
protected:
	void GetFiles(LPCSTR lpcszPath, const vector<string> &vsFileExt, vector<string>& vsFiles)
	{
		for(int ii = 0; ii < vsFileExt.GetSize(); ii++)
		{
			vector<string> vsFindFiles;
			FindFiles(vsFindFiles, lpcszPath, vsFileExt[ii]);
			vsFiles.Append(vsFindFiles);
		}		
	}
	//------ Folger 08/20/07 ADD_BOOLEAN_CONTROL_COPY_DIRECTION
	//int CopyFiles(const vector<string> vsFileNames)
	int CopyFiles(vector<string> &vsFileNames, bool bToGroup = true, bool bGroupMgr = true)
	//------ End ADD_BOOLEAN_CONTROL_COPY_DIRECTION
	{
		//------ Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80
		//string strUserFolder = okutil_get_origin_path(ORIGIN_PATH_USER);
		//string strGroupFolder = okutil_get_origin_path(ORIGIN_PATH_GROUP);
		string strUserFolder, strGroupFolder;
		//--- CPY 9/1/2007 CLEAN_UP_CODE_RELATED_TO_GETTING_75_FDF_FILES
		/*
		if (bGroupMgr)
		{
			strUserFolder = okutil_get_origin_path(ORIGIN_PATH_USER);
			strGroupFolder = okutil_get_origin_path(ORIGIN_PATH_GROUP);
		}
		else
		{
			//------ Folger 08/31/07 USE_OKUTIL_FUNCTION_GET_ORIGIN75_USER_PATH
			//Registry reg(HKEY_CURRENT_USER);
			//string strKey = "Software\\OriginLab\\Origin 7.5\\English\\";
			//if (!reg.GetValue(strKey, "Path", m_strUserPath))
				//return;
			strUserFolder = okutil_get_origin_path(ORIGIN_PATH_USER_PREV_VER);
			//------ End USE_OKUTIL_FUNCTION_GET_ORIGIN75_USER_PATH
			strGroupFolder = okutil_get_origin_path(ORIGIN_PATH_USER);
		}
		*/
		if(!GetSourceDestFilePath(strUserFolder, strGroupFolder, bGroupMgr))
			return 0;
		//--- end CLEAN_UP_CODE_RELATED_TO_GETTING_75_FDF_FILES 
		//------ End SUPPORT_TRANSFER_FILES_FROM_75_TO_80
		
		// copy files
		int nFileCopied = 0;
		for (int ii = 0; ii < vsFileNames.GetSize(); ii++)
		{
			string strDestFile, strDestPath;
			strDestFile = vsFileNames[ii];
			//------ Folger 08/20/07 ADD_BOOLEAN_CONTROL_COPY_DIRECTION
			//strDestFile.Replace(strUserFolder, strGroupFolder);
			if (bToGroup)
				strDestFile.Replace(strUserFolder, strGroupFolder);
			else
				strDestFile.Replace(strGroupFolder, strUserFolder);
			//------ End ADD_BOOLEAN_CONTROL_COPY_DIRECTION
			
			strDestPath = GetFilePath(strDestFile);
			if ( !strDestPath.IsPath() )
				CheckMakePath(strDestPath);
			
			//------ Folger 09/27/07 RESET_ATTRIBUTE_WHEN_COPY_FILE
			//if ( CopyFile(vsFileNames[ii], strDestFile) )
			if ( !copyfile(vsFileNames[ii], strDestFile, 0) )
			//------ End RESET_ATTRIBUTE_WHEN_COPY_FILE
				nFileCopied++;
			else
			{
				vsFileNames[ii].Empty();
			}
		}
		return nFileCopied;
	}
	//------ CPY 9/1/2007 CLEAN_UP_CODE_RELATED_TO_GETTING_75_FDF_FILES
protected:
	bool GetSourceDestFilePath(string& strUserFolder, string& strGroupFolder, bool bGroupMgr)
	{ 
		if (bGroupMgr)
		{
			strUserFolder = okutil_get_origin_path(ORIGIN_PATH_USER);
			//------ CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH
			//strGroupFolder = okutil_get_origin_path(ORIGIN_PATH_GROUP);
			strGroupFolder = GetGroupFolderPath();
			//------
		}
		else
		{
			//strUserFilePath = GetFunctionFileFullPath(lpcszName, ORIGIN_PATH_USER_PREV_VER);
			if(!get_origin75_user_path(strUserFolder))
				return false;		
			strGroupFolder = okutil_get_origin_path(ORIGIN_PATH_USER);
		}
		return true;
	}
	//------ CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH
	// centralized access to group folder location
	string GetGroupFolderPath(LPCSTR lpcszSubPath=NULL)
	{
		return okutil_get_origin_path(ORIGIN_PATH_SERVER_GROUP_FOLDER, lpcszSubPath, true);
	}
	//------
protected:
	string m_strUserPath;
	string m_strGroupPath;
};

//------ Folger 09/19/08 FIX_TEMPLATE_TRANSFER_FAIL_WHEN_TEMPLATE_XML_IN_UFF_IS_NOT_EXIST
static		void		_check_create_tempalte_xml(const string& strFile)
{
	if ( !strFile.IsFile() )
	{
		Tree trXML;
		load_template_tree(trXML);
		foreach (TreeNode trBranch in trXML.Children)
		{
			trBranch.Reset(true);
		}
		trXML.Save(strFile);
	}
}
//------ End FIX_TEMPLATE_TRANSFER_FAIL_WHEN_TEMPLATE_XML_IN_UFF_IS_NOT_EXIST

class TemplatePublish : public FilePublishBase
{
public:
	TemplatePublish()
	{
		m_strUserPath = okutil_get_origin_path(ORIGIN_PATH_USER, NULL, TRUE);
		//------ CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH
		//m_strGroupPath = okutil_get_origin_path(ORIGIN_PATH_GROUP, NULL, TRUE);
		m_strGroupPath = GetGroupFolderPath();
		//------
	}
	virtual int GetFiles(int nPath, vector<string>& vsFiles)
	{
		//------ Folger 08/23/07 IMPLEMENT_TEMPLATE_PUBLISH
		//vector<string> vsTemplateTypes = {".otp", ".otw", ".otm"};
		//string strPath = okutil_get_origin_path(nPath, NULL, TRUE);
		//GetFiles(strPath, vsTemplateTypes, vsFiles);
		//return vsFiles.GetSize();
		
		Tree trXML;
		
		if (!load_template_tree(trXML, nPath == ORIGIN_PATH_USER ? TEMPLATE_LOCATION_USER_FOLDER : TEMPLATE_LOCATION_SERVER_GROUP_FOLDER))
			return 0;
		
		tree_get_attributes(trXML, vsFiles, STR_FILENAME_ATTRIB);
		
		for (int ii=vsFiles.GetSize()-1; ii>=0; ii--)
		{
			//------ Folger 12/05/07 REMOVE_UNKNOWN_TEMPLATE_SAVED_IN_USER_TEMPLATE_XML
			//if (vsFiles[ii].IsEmpty())
			if (vsFiles[ii].IsEmpty() || (nPath == ORIGIN_PATH_USER && template_get_origin_path_type(vsFiles[ii]) == ORIGIN_PATH_UNDEF))
			//------
				vsFiles.RemoveAt(ii);
			else
				vsFiles[ii] = GetFileName(vsFiles[ii]);
		}
		
		return vsFiles.GetSize();
		
		//------ End IMPLEMENT_TEMPLATE_PUBLISH
	}
	//------ Folger 08/21/07 CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR
	//virtual int PublishFiles(const vector<string> vsFileNames)
	virtual int PublishFiles(vector<string> &vsFileNames, bool bFromuserToGroupFolder = true, bool bGroupMgr = true)
	//------ End CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR
	{
		//------ Folger 08/23/07 IMPLEMENT_TEMPLATE_PUBLISH
		//vector<string> vsTemplateXML;
		//vsTemplateXML.Add(STR_TEMPLATE_XML);
		//CopyFiles(vsTemplateXML);
		//return FilePublishBase::PublishFiles(vsFileNames);
		
		//Load template XML
		Tree trXML;		
		if (!load_template_tree(trXML, bFromuserToGroupFolder ? TEMPLATE_LOCATION_USER_FOLDER : TEMPLATE_LOCATION_SERVER_GROUP_FOLDER))
			return 0;
		//if destination xml files not exist, create it
		Tree trTmp;
		string strPath = bFromuserToGroupFolder ? STR_SERVER_GROUP_TEMPLATE_XML : STR_TEMPLATE_XML;
		
		//------ Folger 09/19/08 FIX_TEMPLATE_TRANSFER_FAIL_WHEN_TEMPLATE_XML_IN_UFF_IS_NOT_EXIST
		//if (!trTmp.Load(strPath))
		//{
			//trXML.Save(strPath);
			//trTmp.Load(strPath);
			//foreach (TreeNode trBranch in trTmp.Children)
			//{
				//trBranch.Reset(true);
			//}
			//trTmp.Save(strPath);
		//}
		_check_create_tempalte_xml(strPath);
		//------ End FIX_TEMPLATE_TRANSFER_FAIL_WHEN_TEMPLATE_XML_IN_UFF_IS_NOT_EXIST
		
		int nSize = vsFileNames.GetSize();
		vector<string> vsFileFullNames(nSize);
		vector<string> vsPictures;		
		
		string strPathFrom, strPathTo;
		if (bFromuserToGroupFolder)
		{
			strPathFrom = m_strUserPath;
			strPathTo = m_strGroupPath;
		}
		else
		{
			strPathFrom = m_strGroupPath;
			strPathTo = m_strUserPath;
		}
//------ Folger 09/24/07 CLEAN_UP_TEMPLATE_PUBLISH_FOR_CORRECT_LOGIC
////------ Folger 08/29/07 SAVE_PARTITIAL_GROUP_PATH_FOR_PUBLISH		
//#ifdef SAVE_PARTITIAL_GROUP_PATH_USING_XML_TREE
//
		//if (!trTmp.Load(strPath))
			//return 0;
//
//#endif
////------ End SAVE_PARTITIAL_GROUP_PATH_FOR_PUBLISH	
//------ End CLEAN_UP_TEMPLATE_PUBLISH_FOR_CORRECT_LOGIC
		for (int ii=0; ii<nSize; ii++)
		{
			vsFileFullNames[ii] = strPathFrom + vsFileNames[ii];
			//add picture
			string strPicture = _check_get_pictrue_name(vsFileFullNames[ii]);
			if (!strPicture.IsEmpty())
				vsPictures.Add(strPicture);
			
			int nTemplateType = _get_template_type_from_name(vsFileNames[ii]);
			TreeNode trBranch = tree_get_node_by_id(trXML, nTemplateType);
			string strCate;

//------ Folger 08/29/07 SAVE_PARTITIAL_GROUP_PATH_FOR_PUBLISH			
			//findTemplate(trBranch, vsFileFullNames[ii], strCate);
			//okutil_add_template(strPath, strCate, strPathTo + vsFileNames[ii], nTemplateType);
			//------ Folger 09/24/07 CLEAN_UP_TEMPLATE_PUBLISH_FOR_CORRECT_LOGIC
			//string strFileFrom = vsFileFullNames[ii];
			//if (!bFromuserToGroupFolder)
				//strFileFrom.Replace(GetAppPath(true), "");
			//findTemplate(trBranch, strFileFrom, strCate);
			findTemplate(trBranch, bFromuserToGroupFolder ? vsFileFullNames[ii] : vsFileNames[ii], strCate);
			//------ End CLEAN_UP_TEMPLATE_PUBLISH_FOR_CORRECT_LOGIC
		
//#ifndef SAVE_PARTITIAL_GROUP_PATH_USING_XML_TREE		//------ Folger 09/24/07 CLEAN_UP_TEMPLATE_PUBLISH_FOR_CORRECT_LOGIC
			//------ Folger 09/29/07 NEW_DISIGN_FOR_SAVING_TEMPLATE_XML
			////------ Folger 08/30/07 USE_NEW_OKUTIL_ADD_TEMPLATE
			//string strFileDes = strPathTo + vsFileNames[ii];
			//if (bFromuserToGroupFolder)
			//{
				////------ Folger 09/24/07 CLEAN_UP_TEMPLATE_PUBLISH_FOR_CORRECT_LOGIC
				////string strAppPath = GetAppPath(true);
				////strFileDes.Replace(strAppPath, "");
				////okutil_add_template(strPath, strCate, strFileDes, nTemplateType, strAppPath);
				//okutil_add_template(strPath, strCate, vsFileNames[ii], nTemplateType, m_strGroupPath);
				////------ End NEW_DISIGN_FOR_SAVING_TEMPLATE_XML
				////------ End CLEAN_UP_TEMPLATE_PUBLISH_FOR_CORRECT_LOGIC
			//}
			//else
				//okutil_add_template(strPath, strCate, strFileDes, nTemplateType);
			////------ End USE_NEW_OKUTIL_ADD_TEMPLATE
			okutil_add_template(strPath, strCate, vsFileNames[ii], nTemplateType);
			//------ End NEW_DISIGN_FOR_SAVING_TEMPLATE_XML
//------ Folger 09/24/07 CLEAN_UP_TEMPLATE_PUBLISH_FOR_CORRECT_LOGIC
//#else
//
			//string strFileDes = strPathTo + vsFileNames[ii];
			//trBranch = tree_get_node_by_id(trTmp, nTemplateType);
			//
			//TreeNode trCate;
			//foreach (TreeNode trNode in trBranch.Children)
			//{
				//string strTmp;
				//trNode.GetAttribute(STR_LABEL_ATTRIB, strTmp);
				//if (strTmp.CompareNoCase(strCate) == 0)
				//{
					//trCate = trNode;
					//break;
				//}
//
			//}
			//
			//if (!trCate)
				//trCate = _tree_add_cate_node(trBranch, strCate);
			//
			//string strTemplate = okutil_composite_name_from_file_path(strFileDes, "Templates");
			//if (strPathTo.CompareNoCase(m_strGroupPath) == 0)
				//strFileDes.Replace(GetAppPath(true), "");
			//
						//
			//_tree_add_temp_node(trCate, strTemplate, strFileDes);
//#endif
//------ End CLEAN_UP_TEMPLATE_PUBLISH_FOR_CORRECT_LOGIC
		}
//------ Folger 09/24/07 CLEAN_UP_TEMPLATE_PUBLISH_FOR_CORRECT_LOGIC		
//#ifdef SAVE_PARTITIAL_GROUP_PATH_USING_XML_TREE		
		//trTmp.Save(strPath);
//#endif
//------ End CLEAN_UP_TEMPLATE_PUBLISH_FOR_CORRECT_LOGIC
//------ End SAVE_PARTITIAL_GROUP_PATH_FOR_PUBLISH
		
		//copy files
		int nRet = CopyFiles(vsFileFullNames, bFromuserToGroupFolder);
		if (nRet != nSize)
		{
			for (ii=nSize-1; ii>=0; ii--)
			{
				if (vsFileFullNames[ii].IsEmpty())
					vsFileNames.RemoveAt(ii);
			}
		}
		if (vsPictures.GetSize())
			CopyFiles(vsPictures, bFromuserToGroupFolder);
		
		return nRet;
		
		//------ End IMPLEMENT_TEMPLATE_PUBLISH		
	}
	
	//------ Folger 08/23/07 IMPLEMENT_TEMPLATE_PUBLISH
	virtual int RemoveFiles(vector<string> &vsFileNames, bool bGroupFolder = true)
	{		
		//Load template XML
		Tree trXML;		
		if (!load_template_tree(trXML, bGroupFolder ? TEMPLATE_LOCATION_SERVER_GROUP_FOLDER : TEMPLATE_LOCATION_USER_FOLDER))
			return 0;
		
		int nSize = vsFileNames.GetSize();
		for (int ii=nSize-1; ii>=0; ii--)
		{
			string strFileFullName = (bGroupFolder ? m_strGroupPath : m_strUserPath) + vsFileNames[ii];
			//------ Folger 09/24/07 CLEAN_UP_TEMPLATE_PUBLISH_FOR_CORRECT_LOGIC
			////------ Folger 08/29/07 SAVE_PARTITIAL_GROUP_PATH_FOR_PUBLISH
			//if (bGroupFolder)
				//strFileFullName.Replace(GetAppPath(true), "");
			////------ End SAVE_PARTITIAL_GROUP_PATH_FOR_PUBLISH
			//TreeNode trNode = trXML.FindNodeByAttribute(STR_FILENAME_ATTRIB, strFileFullName);
			//------ Folger 09/29/07 NEW_DISIGN_FOR_SAVING_TEMPLATE_XML
			//TreeNode trNode = trXML.FindNodeByAttribute(STR_FILENAME_ATTRIB, bGroupFolder ? vsFileNames[ii] : strFileFullName);
			TreeNode trNode = trXML.FindNodeByAttribute(STR_NAME_ATTRIB, vsFileNames[ii]);
			//------ End NEW_DISIGN_FOR_SAVING_TEMPLATE_XML
			//------ End CLEAN_UP_TEMPLATE_PUBLISH_FOR_CORRECT_LOGIC
			if (trNode)
				trNode.Remove();
			if (bGroupFolder)
			{
				//------ Folger 09/24/07 CLEAN_UP_TEMPLATE_PUBLISH_FOR_CORRECT_LOGIC
				//strFileFullName.Insert(0, GetAppPath(true));	//------ Folger 08/29/07 SAVE_PARTITIAL_GROUP_PATH_FOR_PUBLISH
				//------ End CLEAN_UP_TEMPLATE_PUBLISH_FOR_CORRECT_LOGIC
				//------ Folger 09/27/07 DELETE_FILE_REGARDLESS_OF_READ_ONLY
				//if (!DeleteFile(strFileFullName))
				if (!okutil_delete_file(strFileFullName, true))
				//------ End DELETE_FILE_REGARDLESS_OF_READ_ONLY
					vsFileNames.RemoveAt(ii);
				//delete picture
				string strPicture = _check_get_pictrue_name(strFileFullName);
				if (!strPicture.IsEmpty())
					//------ Folger 09/27/07 DELETE_FILE_REGARDLESS_OF_READ_ONLY
					//DeleteFile(strPicture);
					okutil_delete_file(strPicture, true);
					//------ End DELETE_FILE_REGARDLESS_OF_READ_ONLY
			}				
		}
		
		trXML.Save(bGroupFolder ? STR_SERVER_GROUP_TEMPLATE_XML : STR_TEMPLATE_XML);
		return vsFileNames.GetSize();
	}
	//------ End IMPLEMENT_TEMPLATE_PUBLISH
	
private:
	//------ Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80
	//int getTemplateTypeFromName(LPCSTR lpcszFileName)
	//{
		//string strName, strExt;
		//separate_file_name_ext(lpcszFileName, &strName, &strExt);
		//if(strExt.Left(1) == ".")
			//strExt = strExt.GetToken(1, '.');
		//if(!strExt.CompareNoCase("otp"))
			//return EXIST_GRAPH;
		//if(!strExt.CompareNoCase("otw"))
			//return EXIST_WKS;
		//if(!strExt.CompareNoCase("otm"))
			//return EXIST_MATRIX;
		//return EXIST_NONE;
	//}
	//------ End SUPPORT_TRANSFER_FILES_FROM_75_TO_80
	bool findTemplate(TreeNode& trBranch, string strFile, string& strCate)
	{
		TreeNode tr;
		if(trBranch.IsValid())
			tr = trBranch.FindNodeByAttribute(STR_FILENAME_ATTRIB, strFile);
		if(!tr.IsValid() || !tr.Parent().IsValid())
			return false;
		tr = tr.Parent();
		tr.GetAttribute(STR_LABEL_ATTRIB, strCate);
		if(!lstrlen(strCate))
			strCate = tr.tagName;
		return true;
	}
	//------ Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80
	//string checkGetPictrueName(LPCSTR lpcszFileFullName)
	//{
		//char szFileName[100];
		//char szExt[20];
		//string strRet;
		//
		//lstrcat(szFileName, lpcszFileFullName);
		//check_add_file_ext(szFileName, NULL, szExt);
		//string strExt = szExt;
		//
		//if (strExt.CompareNoCase("OTP") == 0)
		//{
			//string strPicture = get_graph_template_preview_file(lpcszFileFullName);
			//lstrcat(szFileName, strPicture);
			//check_add_file_ext(szFileName, NULL, szExt);
			//string strNameOnly = GetFileName(lpcszFileFullName, true);
			//string strPath = GetFilePath(lpcszFileFullName);
			//strRet = strPath + strNameOnly + '.' + szExt;
		//}
		//
		//return strRet;
	//}
	//------ End SUPPORT_TRANSFER_FILES_FROM_75_TO_80
};

class ImpFilterPublish : public FilePublishBase
{
public:
	ImpFilterPublish()
	{
		m_strUserPath = okutil_get_origin_path(ORIGIN_PATH_USER, FILTERS_FOLDER_NAME, TRUE);
		//------ CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH
		//m_strGroupPath = okutil_get_origin_path(ORIGIN_PATH_GROUP, FILTERS_FOLDER_NAME, TRUE);
		m_strGroupPath = GetGroupFolderPath(FILTERS_FOLDER_NAME);
		//------
	}
	virtual int GetFiles(int nPath, vector<string>& vsFiles)
	{ 
		/// Hong 08/15/07 v8.0682 PUBLISH_FILTER_WITH_DRAG_AND_GROP_SETTING
		//return -1;
		vector<string> vsExt = {IMPORT_FILTER_EXTENSION};
		string strPath = okutil_get_origin_path(nPath, NULL, TRUE) + FILTERS_FOLDER_NAME;
		GetFiles(strPath, vsExt, vsFiles);
		return vsFiles.GetSize();
		/// end PUBLISH_FILTER_WITH_DRAG_AND_GROP_SETTING
	}
	//------ Folger 08/21/07 CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR
	//virtual int PublishFiles(const vector<string> vsFileNames)
	virtual int PublishFiles(vector<string> &vsFileNames, bool bFromuserToGroupFolder = true, bool bGroupMgr = true)
	//------ End CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR
	{ 
		/// Hong 08/15/07 v8.0682 PUBLISH_FILTER_WITH_DRAG_AND_GROP_SETTING
		//return -1;
		//------ Folger 08/21/07 CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR
		//vector<string> vsFilterINI;
		//vsFilterINI.Add(STR_FILTER_INI_FILENAME);
		//CopyFiles(vsFilterINI);
		//return FilePublishBase::PublishFiles(vsFileNames);
		
		int nSize = vsFileNames.GetSize();
		vector<string> vsFileFullNames(nSize);
		for (int ii=0; ii<nSize; ii++)
		{
			vsFileFullNames[ii] = (bFromuserToGroupFolder ? m_strUserPath : m_strGroupPath) + vsFileNames[ii];
			bool bValue;
			//------ CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH
			//string strGroupPath = okutil_get_origin_path(ORIGIN_PATH_GROUP, NULL, TRUE);
			string strGroupPath = GetGroupFolderPath();
			//------
			string strFileName = GetFilenameWithoutExt(vsFileNames[ii]);
			if (get_filter_setting(strFileName,
									bValue,
									bFromuserToGroupFolder ? FILTER_LOCATION_USER_FOLDER : FILTER_LOCATION_GROUP_FOLDER,
									FILTER_SETTING_DRAG_AND_DROG,
									bFromuserToGroupFolder ? "" : strGroupPath))
			{
				set_filter_setting(strFileName,
									bValue,
									bFromuserToGroupFolder ? FILTER_LOCATION_GROUP_FOLDER : FILTER_LOCATION_USER_FOLDER,
									FILTER_SETTING_DRAG_AND_DROG,
									bFromuserToGroupFolder ? strGroupPath : "");
			}
		}
		
		int nRet = CopyFiles(vsFileFullNames, bFromuserToGroupFolder);
		
		if (nRet != nSize)
		{
			for (ii=nSize-1; ii>=0; ii--)
			{
				if (vsFileFullNames[ii].IsEmpty())
					vsFileNames.RemoveAt(ii);
			}
		}
		
		return nRet;
		
		//------ End CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR
		
		/// end PUBLISH_FILTER_WITH_DRAG_AND_GROP_SETTING
	}
	
	//------ Folger 08/21/07 CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR
	virtual int RemoveFiles(vector<string> &vsFileNames, bool bGroupFolder = true)
	{
		int nSize = vsFileNames.GetSize();
		for (int ii=nSize-1; ii>=0; ii--)
		{
			string strFileFullName = (bGroupFolder ? m_strGroupPath : m_strUserPath) + vsFileNames[ii];
			bool bValue;
			//------ CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH 
			//string strGroupPath = okutil_get_origin_path(ORIGIN_PATH_GROUP, NULL, TRUE);
			string strGroupPath = GetGroupFolderPath();
			//------
			string strFileName = GetFilenameWithoutExt(vsFileNames[ii]);
			if (get_filter_setting(strFileName,
									bValue,
									bGroupFolder ? FILTER_LOCATION_GROUP_FOLDER : FILTER_LOCATION_USER_FOLDER,
									FILTER_SETTING_DRAG_AND_DROG,
									bGroupFolder ? strGroupPath : ""))
			{
				remove_line_from_filter_setting(strFileName,
												bGroupFolder ? FILTER_LOCATION_GROUP_FOLDER : FILTER_LOCATION_USER_FOLDER,
												FILTER_SETTING_DRAG_AND_DROG,
												bGroupFolder ? strGroupPath : "");
			}
			//------ Folger 09/27/07 DELETE_FILE_REGARDLESS_OF_READ_ONLY
			//if (!DeleteFile(strFileFullName))
			if (!okutil_delete_file(strFileFullName, true))
			//------ End DELETE_FILE_REGARDLESS_OF_READ_ONLY
				vsFileNames.RemoveAt(ii);
		}
		return vsFileNames.GetSize();
	}
	//------ End CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR
};

class FDFPublish : public FilePublishBase
{
public:
	FDFPublish()
	{
		//------ Folger 09/11/07 FIX_BUGS_IN_FDF_FILE_COMPARE
		//m_strUserPath = okutil_get_origin_path(ORIGIN_PATH_USER, NULL, TRUE) + STR_FDF_FILE_FOLDER;
		//m_strGroupPath = okutil_get_origin_path(ORIGIN_PATH_GROUP, NULL, TRUE) + STR_FDF_FILE_FOLDER;
		m_strUserPath = okutil_get_origin_path(ORIGIN_PATH_USER, NULL, TRUE) + STR_FDF_FILE_FOLDER_BACKSLASH;
		//------ CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH
		//m_strGroupPath = okutil_get_origin_path(ORIGIN_PATH_GROUP, NULL, TRUE) + STR_FDF_FILE_FOLDER_BACKSLASH;
		m_strGroupPath = GetGroupFolderPath(STR_FDF_FILE_FOLDER_BACKSLASH);
		//------
		//------ End FIX_BUGS_IN_FDF_FILE_COMPARE
	}
	//------ Folger 08/22/07 UNFIY_FUNC_GET_FILES_INTERFACE
	//virtual int GetFiles(int nPath, vector<string>& vsFiles, bool bGroupFolder = true)
	virtual int GetFiles(int nPath, vector<string>& vsFiles)
	//------ End UNFIY_FUNC_GET_FILES_INTERFACEs
	{ 
		/// Hong 08/20/07 v8.0685 CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR
		//vector<string> vsExt = {STR_FDF_FILE_EXT};
		//string strPath = okutil_get_origin_path(nPath, NULL, TRUE) + STR_FDF_FILE_FOLDER;
		//GetFiles(strPath, vsExt, vsFiles);
		bool bGroupFolder = nPath == ORIGIN_PATH_SERVER_GROUP_FOLDER;		//------ Folger 08/22/07 UNFIY_FUNC_GET_FILES_INTERFACE
		//------ Folger 09/04/07 GET_NLFIT_FILE_NAME_INSTEAD_OF_FUNCTION_NAME
		//vector<string> vsFullFileNames;
		//m_gfo.GetFilesList(vsFiles, vsFullFileNames, bGroupFolder);
		vector<string> vsFunctions;
		m_gfo.GetFilesList(vsFunctions, vsFiles, bGroupFolder);
		//------ End GET_NLFIT_FILE_NAME_INSTEAD_OF_FUNCTION_NAME
		/// end CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR
		//------ Folger 09/11/07 FIX_BUGS_IN_FDF_FILE_COMPARE
		//return vsFiles.GetSize();		
		return _append_file_ext(vsFiles, STR_FDF_FILE_EXT);
		//------ End FIX_BUGS_IN_FDF_FILE_COMPARE
	}
	virtual int PublishFiles(vector<string> &vsFileNames, bool bFromuserToGroupFolder = true, bool bGroupMgr = true)
	{ 
		/// Hong 08/20/07 v8.0685 CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR
		/*
		vector<string> vsNLSFini;
		vsNLSFini.Add(nlf_get_ini_filepath());		
		CopyFiles(vsNLSFini);
		return FilePublishBase::PublishFiles(vsFileNames);
		*/
		int nNum = 0;
		for (int ii = 0; ii < vsFileNames.GetSize(); ii++)
		{
			//------ Folger 09/11/07 FIX_BUGS_IN_FDF_FILE_COMPARE
			//if ( m_gfo.AddFile(vsFileNames[ii], bFromuserToGroupFolder) )
			string strFile = vsFileNames[ii];
			strFile.Replace(STR_FDF_FILE_EXT, "");
			if ( m_gfo.AddFile(strFile, bFromuserToGroupFolder) )
			//------ End FIX_BUGS_IN_FDF_FILE_COMPARE
				nNum++;
			else
				vsFileNames.RemoveAt(ii--);
		}
		
		return nNum;
		/// end CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR
	}
	/// Hong 08/20/07 v8.0685 CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR
	virtual int RemoveFiles(vector<string> &vsFileNames, bool bGroupFolder = true)
	{
		int nNum = 0;
		for (int ii = 0; ii < vsFileNames.GetSize(); ii++)
		{
			//------ Folger 09/11/07 FIX_BUGS_IN_FDF_FILE_COMPARE
			//if ( m_gfo.RemoveFile(vsFileNames[ii], bGroupFolder) )
			string strFile = vsFileNames[ii];
			strFile.Replace(STR_FDF_FILE_EXT, "");
			if ( m_gfo.RemoveFile(strFile, bGroupFolder) )
			//------ End FIX_BUGS_IN_FDF_FILE_COMPARE
				nNum++;
			else
				vsFileNames.RemoveAt(ii--);
		}
		
		return nNum;
	}
	/// end CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR
	
private:
	GroupFunctionOrganizer	m_gfo;
};
//------ Folger 08/27/07 ADD_FILETYPES_OGS_THEME_XF
class OGSPublish : public FilePublishBase
{
public:
	OGSPublish()
	{
		m_strUserPath = okutil_get_origin_path(ORIGIN_PATH_USER, NULL, TRUE);
		//------ CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH
		//m_strGroupPath = okutil_get_origin_path(ORIGIN_PATH_GROUP, NULL, TRUE);
		m_strGroupPath = GetGroupFolderPath();
		//------
	}
	
	virtual int GetFiles(int nPath, vector<string>& vsFiles)
	{
		//------ Folger 09/03/07 SUPPORT_MORE_FILE_TYPES
		//string strFile;
		//GetFilenamesInFolder(strFile, nPath == ORIGIN_PATH_USER ? m_strUserPath : m_strGroupPath,  "*.ogs");
		//strFile.GetTokens(vsFiles, '|');
		//
		//int nSize = vsFiles.GetSize();
		//for (int ii=0; ii<nSize; ii++)
		//{
			//vsFiles[ii] = GetFileName(vsFiles[ii]);
		//}
		vector<string> vsExt = {".ogs"};
		GetFiles(nPath == ORIGIN_PATH_USER ? m_strUserPath : m_strGroupPath, vsExt, vsFiles);
		//------ End SUPPORT_MORE_FILE_TYPES
		return vsFiles.GetSize();
	}
	//------ Folger 09/03/07 SUPPORT_MORE_FILE_TYPES
	//virtual int PublishFiles(vector<string> &vsFileNames, bool bFromuserToGroupFolder = true, bool bGroupMgr = true)
	//{
		//int nSize = vsFileNames.GetSize();
		//
		//vector<string> vsFileFullNames(nSize);
		//string strPath = bFromuserToGroupFolder ? m_strUserPath : m_strGroupPath;
		//
		//for(int ii=0; ii<nSize; ii++)
		//{
			//vsFileFullNames[ii] = strPath + vsFileNames[ii];
		//}
		//
		//int nRet = CopyFiles(vsFileFullNames, bFromuserToGroupFolder);
		//
		//if (nRet)
		//{
			//FilePublishBase::PublishFiles(vsFileNames);
		//}
		//
		//return nRet;
	//}
	
	//virtual int RemoveFiles(vector<string> &vsFileNames, bool bGroupFolder = true)
	//{
		//int nSize = vsFileNames.GetSize();
		//
		//string strPath = bGroupFolder ? m_strGroupPath : m_strUserPath;
		//
		//for(int ii=0; ii<nSize; ii++)
		//{
			//DeleteFile(strPath + vsFileNames[ii]);
		//}
		//
		//return nSize;
	//}
	//------ End SUPPORT_MORE_FILE_TYPES
};
//------ Folger 08/27/07 CREATE_FILE_CATEGORY_PUBLISH_TO_SUPPORT_GRID_WITH_CATEGORY
class FileCategoryPublish : public FilePublishBase
{
	FileCategoryPublish(string strFileExts)
	{
		strFileExts.GetTokens(m_vsFileExts, '|');
	}
	
	virtual int GetColNames(vector<string> &vsColNames,int nPath)
	{
		FilePublishBase::GetColNames(vsColNames, nPath);
		vsColNames.Add(_L("Category"));
		return vsColNames.GetSize();
	}
	
	virtual int GetRowInfo(string strKey, vector<string> &vsRowInfo, int nPath)
	{
		vsRowInfo.Add(GetFileName(strKey));
		vsRowInfo.Add(GetFilePath(strKey));
		return vsRowInfo.GetSize();
	}
	
	virtual int GetFiles(int nPath, vector<string>& vsFiles)
	{
		bool bUser = nPath == ORIGIN_PATH_USER;
		
		for (int ii=0; ii<m_vsFileExts.GetSize(); ii++)
		{
			string strFile;
			GetFilenamesInFolder(strFile, bUser ? m_strUserPath : m_strGroupPath, m_vsFileExts[ii], true);
			vector<string> vsTmp;
			strFile.GetTokens(vsTmp, '|');
			vsFiles.Append(vsTmp);
		}
		int nSize = vsFiles.GetSize();
		if (bUser)
		{
			m_vsXFUserFullFiles = vsFiles;
			m_vsXFUserFiles.SetSize(nSize);
		}
		else
		{
			m_vsXFGroupFullFiles = vsFiles;
			m_vsXFGroupFiles.SetSize(nSize);
		}
		for (ii=0; ii<nSize; ii++)
		{
			if (bUser)
			{
				vsFiles[ii].Replace(m_strUserPath, "");
				m_vsXFUserFiles[ii] = vsFiles[ii];
			}
			else
			{
				vsFiles[ii].Replace(m_strGroupPath, "");
				m_vsXFGroupFiles[ii] = vsFiles[ii];
			}
		}
		return nSize;
	}
	
	virtual int PublishFiles(vector<string> &vsFileNames, bool bFromuserToGroupFolder = true, bool bGroupMgr = true)
	{
		int nSize = vsFileNames.GetSize();
		
		vector<string> vsFileFullNames(nSize);
		
		if (bFromuserToGroupFolder)
		{
			for(int ii=0; ii<nSize; ii++)
			{
				int nIndex = m_vsXFUserFiles.Find(vsFileNames[ii]);
				vsFileFullNames[ii] = m_vsXFUserFullFiles[nIndex];
				if (m_vsXFGroupFiles.Find(vsFileNames[ii]) < 0)
				{
					m_vsXFGroupFiles.Add(vsFileNames[ii]);
					m_vsXFGroupFullFiles.Add(vsFileFullNames[ii]);
					m_vsXFGroupFullFiles[m_vsXFGroupFullFiles.GetSize()-1].Replace(m_strUserPath, m_strGroupPath);
				}
			}
		}
		else
		{
			for(int ii=0; ii<nSize; ii++)
			{
				int nIndex = m_vsXFGroupFiles.Find(vsFileNames[ii]);
				vsFileFullNames[ii] = m_vsXFGroupFullFiles[nIndex];
				if (m_vsXFUserFiles.Find(vsFileNames[ii]) < 0)
				{
					m_vsXFUserFiles.Add(vsFileNames[ii]);
					m_vsXFUserFullFiles.Add(vsFileFullNames[ii]);
					m_vsXFUserFullFiles[m_vsXFUserFullFiles.GetSize()-1].Replace(m_strGroupPath, m_strUserPath);
				}
			}
		}
		
		int nRet = CopyFiles(vsFileFullNames, bFromuserToGroupFolder);
		if (nRet != nSize)
		{
			for (int ii=nSize-1; ii>=0; ii--)
			{
				if (vsFileFullNames[ii].IsEmpty())
				{
					if (bFromuserToGroupFolder)
					{
						int nIndex = m_vsXFUserFiles.Find(vsFileNames[ii]);
						m_vsXFUserFiles.RemoveAt(nIndex);
						m_vsXFUserFullFiles.RemoveAt(nIndex);
					}
					else
					{
						int nIndex = m_vsXFGroupFiles.Find(vsFileNames[ii]);
						m_vsXFGroupFiles.RemoveAt(nIndex);
						m_vsXFGroupFullFiles.RemoveAt(nIndex);
					}
					vsFileNames.RemoveAt(ii);
				}
			}
		}
		
		return nRet;
	}
	
	virtual int RemoveFiles(vector<string> &vsFileNames, bool bGroupFolder = true)
	{
		int nSize = vsFileNames.GetSize();
		if (bGroupFolder)
		{
			for (int ii=nSize-1; ii>=0; ii--)
			{
				int nIndex = m_vsXFGroupFiles.Find(vsFileNames[ii]);
				//------ Folger 09/27/07 DELETE_FILE_REGARDLESS_OF_READ_ONLY
				//if (DeleteFile(m_vsXFGroupFullFiles[nIndex]))
				if (okutil_delete_file(m_vsXFGroupFullFiles[nIndex], true))
				//------ End DELETE_FILE_REGARDLESS_OF_READ_ONLY
				{
					m_vsXFGroupFiles.RemoveAt(nIndex);
					m_vsXFGroupFullFiles.RemoveAt(nIndex);
				}
				else
				{
					vsFileNames.RemoveAt(ii);
				}
			}
		}
		else
		{
			for (int ii=nSize-1; ii>=0; ii--)
			{
				int nIndex = m_vsXFUserFiles.Find(vsFileNames[ii]);
				//------ Folger 09/27/07 DELETE_FILE_REGARDLESS_OF_READ_ONLY
				//if (DeleteFile(m_vsXFUserFullFiles[nIndex]))
				if (okutil_delete_file(m_vsXFUserFullFiles[nIndex], true))
				//------ End DELETE_FILE_REGARDLESS_OF_READ_ONLY
				{
					m_vsXFUserFiles.RemoveAt(nIndex);
					m_vsXFUserFullFiles.RemoveAt(nIndex);
				}
				else
				{
					vsFileNames.RemoveAt(ii);
				}
			}
		}
		return vsFileNames.GetSize();
	}
	
protected:
		
	vector<string> 	m_vsXFUserFiles;
	vector<string> 	m_vsXFGroupFiles;
	vector<string> 	m_vsXFUserFullFiles;
	vector<string> 	m_vsXFGroupFullFiles;
	vector<string>	m_vsFileExts;
};

//#define STR_GRAPH_THEME_FOLDER			"Graph\\"
//#define STR_WORKSHEET_THEME_FOLDER		"Worksheet\\"
//#define STR_DIALOG_THEME_FOLDER			"AnalysisAndReportTable\\"
#define STR_THEME_FILE_FOLDER			"Themes\\"

class ThemePublish : public FileCategoryPublish
{
public:
	ThemePublish() : FileCategoryPublish("*.oth")
	{
		m_strUserPath = okutil_get_origin_path(ORIGIN_PATH_USER, STR_THEME_FILE_FOLDER, TRUE);
		//------ CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH
		//m_strGroupPath = okutil_get_origin_path(ORIGIN_PATH_GROUP, STR_THEME_FILE_FOLDER, TRUE);
		m_strGroupPath = GetGroupFolderPath(STR_THEME_FILE_FOLDER);
		//------
	}
	
	//virtual int GetFiles(int nPath, vector<string>& vsFiles)
	//{
		//
		//return vsFiles.GetSize();
	//}
	//
	//virtual int PublishFiles(vector<string> &vsFileNames, bool bFromuserToGroupFolder = true, bool bGroupMgr = true)
	//{ 
		//return 0;
	//}
	//
	//virtual int RemoveFiles(vector<string> &vsFileNames, bool bGroupFolder = true)
	//{
		//return 0;
	//}

};

class XFPublish : public FileCategoryPublish
{
public:
	XFPublish() : FileCategoryPublish("*.oxf")
	{
		m_strUserPath = okutil_get_origin_path(ORIGIN_PATH_USER, STR_XF_FILE_FOLDER, TRUE);
		//------ CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH
		//m_strGroupPath = okutil_get_origin_path(ORIGIN_PATH_GROUP, STR_XF_FILE_FOLDER, TRUE);
		m_strGroupPath = GetGroupFolderPath(STR_XF_FILE_FOLDER);
		//------
	}
};

//class XFPublish : public FilePublishBase
//{
//public:
	//XFPublish()
	//{
		//m_strUserPath = okutil_get_origin_path(ORIGIN_PATH_USER, NULL, TRUE) + STR_XF_FILE_FOLDER + "\\";
		//m_strGroupPath = okutil_get_origin_path(ORIGIN_PATH_GROUP, NULL, TRUE) + STR_XF_FILE_FOLDER + "\\";
	//}
	//
	//virtual int GetColNames(vector<string> &vsColNames,int nPath)
	//{
		//FilePublishBase::GetColNames(vsColNames, nPath);
		//vsColNames.Add(_L("Category"));
		//return vsColNames.GetSize();
	//}
	//
	//virtual int GetRowInfo(string strKey, vector<string> &vsRowInfo, int nPath)
	//{
		//vsRowInfo.Add(strKey);
		//int nIndex;
		//string strCate;
		//if (nPath == ORIGIN_PATH_USER)
		//{
			//nIndex = m_vsXFUserFiles.Find(strKey);
			//if (nIndex < 0)
			//{
				//nIndex = m_vsXFGroupFiles.Find(strKey);
				//strCate = m_vsXFGroupFullFiles[nIndex];
				//strCate.Replace(m_strGroupPath, m_strUserPath);
				//m_vsXFUserFiles.Add(strKey);
				//m_vsXFUserFullFiles.Add(strCate);
			//}
			//else
				//strCate = m_vsXFUserFullFiles[nIndex];
			//
			//strCate.Replace(m_strUserPath, "");
		//}
		//else
		//{
			//nIndex = m_vsXFGroupFiles.Find(strKey);
			//if (nIndex < 0)
			//{
				//nIndex = m_vsXFUserFiles.Find(strKey);
				//strCate = m_vsXFUserFullFiles[nIndex];
				//strCate.Replace(m_strUserPath, m_strGroupPath);
				//m_vsXFGroupFiles.Add(strKey);
				//m_vsXFGroupFullFiles.Add(strCate);
			//}
			//else
				//strCate = m_vsXFGroupFullFiles[nIndex];
			//
			//strCate.Replace(m_strGroupPath, "");
		//}
		//strCate.Replace(strKey, "");
		//vsRowInfo.Add(strCate);
		//return vsRowInfo.GetSize();
	//}
	//
	//virtual int GetFiles(int nPath, vector<string>& vsFiles)
	//{
		//bool bUser = nPath == ORIGIN_PATH_USER;
		//string strFile;
		//GetFilenamesInFolder(strFile, bUser ? m_strUserPath : m_strGroupPath,  "*.oxf", true);
		//strFile.GetTokens(vsFiles, '|');
		//int nSize = vsFiles.GetSize();
		//if (bUser)
		//{
			//m_vsXFUserFullFiles = vsFiles;
			//m_vsXFUserFiles.SetSize(nSize);
		//}
		//else
		//{
			//m_vsXFGroupFullFiles = vsFiles;
			//m_vsXFGroupFiles.SetSize(nSize);
		//}
		//for (int ii=0; ii<nSize; ii++)
		//{
			//vsFiles[ii] = GetFileName(vsFiles[ii]);
			//if (bUser)
				//m_vsXFUserFiles[ii] = vsFiles[ii];
			//else
				//m_vsXFGroupFiles[ii] = vsFiles[ii];
		//}
		//return nSize;
	//}
	//
	//virtual int PublishFiles(vector<string> &vsFileNames, bool bFromuserToGroupFolder = true, bool bGroupMgr = true)
	//{
		//int nSize = vsFileNames.GetSize();
		//
		//vector<string> vsFileFullNames(nSize);
		//
		//if (bFromuserToGroupFolder)
		//{
			//for(int ii=0; ii<nSize; ii++)
			//{
				//int nIndex = m_vsXFUserFiles.Find(vsFileNames[ii]);
				//vsFileFullNames[ii] = m_vsXFUserFullFiles[nIndex];
			//}
		//}
		//else
		//{
			//for(int ii=0; ii<nSize; ii++)
			//{
				//int nIndex = m_vsXFGroupFiles.Find(vsFileNames[ii]);
				//vsFileFullNames[ii] = m_vsXFGroupFullFiles[nIndex];
			//}
		//}
		//
		//int nRet = CopyFiles(vsFileFullNames, bFromuserToGroupFolder);
		//
		//if (nRet)
		//{
			//FilePublishBase::PublishFiles(vsFileNames);
		//}
		//
		//return nRet;
	//}
	//
	//virtual int RemoveFiles(vector<string> &vsFileNames, bool bGroupFolder = true)
	//{
		//int nSize = vsFileNames.GetSize();
		//if (bGroupFolder)
		//{
			//for (int ii=0; ii<nSize; ii++)
			//{
				//int nIndex = m_vsXFGroupFiles.Find(vsFileNames[ii]);
				//DeleteFile(m_vsXFGroupFullFiles[nIndex]);
				//m_vsXFGroupFiles.RemoveAt(nIndex);
				//m_vsXFGroupFullFiles.RemoveAt(nIndex);
			//}
		//}
		//else
		//{
			//for (int ii=0; ii<nSize; ii++)
			//{
				//int nIndex = m_vsXFUserFiles.Find(vsFileNames[ii]);
				//DeleteFile(m_vsXFUserFullFiles[nIndex]);
				//m_vsXFUserFiles.RemoveAt(nIndex);
				//m_vsXFUserFullFiles.RemoveAt(nIndex);
			//}
		//}
		//return nSize;
	//}
	//
//private:
		//
	//vector<string> m_vsXFUserFiles;
	//vector<string> m_vsXFGroupFiles;
	//vector<string> m_vsXFUserFullFiles;
	//vector<string> m_vsXFGroupFullFiles;
//};
//------ End CREATE_FILE_CATEGORY_PUBLISH_TO_SUPPORT_GRID_WITH_CATEGORY
//------ End ADD_FILETYPES_OGS_THEME_XF
//------ Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80

//------ Folger 03/20/08 QA80-11192 SUPPORT_DEFAULT_SETTINGS_FILE
class DefaultSettingsPublish : public FilePublishBase
{
public:
	DefaultSettingsPublish()
	{
		GetSourceDestFilePath(m_strUserPath, m_strGroupPath, true);
	}
	virtual int GetFiles(int nPath, vector<string>& vsFiles)
	{
		FindFiles(vsFiles, nPath == ORIGIN_PATH_USER ? m_strUserPath : m_strGroupPath, "Defaults.xml");
		return vsFiles.GetSize();
	}
};
//------ End SUPPORT_DEFAULT_SETTINGS_FILE

//------ Folger 09/03/07 SUPPORT_MORE_FILE_TYPES
class ProjectPublish : public FilePublishBase
{
public:
	/// EJP 2007-10-02 v8.0714 QA70-10469 MORE_WORK_FOR_OPX_AND_GROUP_FOLDER
	///	//------ Folger 09/14/07 REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR
	///	//ProjectPublish(bool bGroupMgr = true)
	///	ProjectPublish(string strFileExt, bool bGroupMgr = true)
	///	//------ End REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR
	ProjectPublish(string strFileExt, bool bGroupMgr = true, LPCSTR lpcszSubPath = NULL)
	/// end MORE_WORK_FOR_OPX_AND_GROUP_FOLDER
	{
		GetSourceDestFilePath(m_strUserPath, m_strGroupPath, bGroupMgr);

		/// EJP 2007-10-02 v8.0714 QA70-10469 MORE_WORK_FOR_OPX_AND_GROUP_FOLDER
		if( lpcszSubPath )
		//------ Folger 10/08/07 QA70-10469 FIX_OPX_FILES_CANNOT_BE_SEEN_IN_GORUPMGR_GROUP_SIDE
			//m_strUserPath += lpcszSubPath;
		{
			m_strUserPath += lpcszSubPath;
			m_strGroupPath += lpcszSubPath;
		}
		//------ End QA70-10469 FIX_OPX_FILES_CANNOT_BE_SEEN_IN_GORUPMGR_GROUP_SIDE
		/// end MORE_WORK_FOR_OPX_AND_GROUP_FOLDER

		m_bGroupMgr = bGroupMgr;
		m_strFileExt = strFileExt;
	}
	
	virtual int GetFiles(int nPath, vector<string>& vsFiles)
	{
		//------ Folger 09/14/07 REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR
		//vector<string> vsExt = {".opj", ".ogw"};
		vector<string> vsExt;
		m_strFileExt.GetTokens(vsExt, '|');
		//------ End REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR
		string strPath;
		if (m_bGroupMgr)
			strPath = nPath == ORIGIN_PATH_USER ? m_strUserPath : m_strGroupPath;
		else
			strPath = nPath == ORIGIN_PATH_USER ? m_strGroupPath : m_strUserPath;
		GetFiles(strPath, vsExt, vsFiles);
		return vsFiles.GetSize();
	}
	
	virtual int PublishFiles(vector<string> &vsFileNames, bool bFromuserToGroupFolder = true, bool bGroupMgr = true)
	{
		return FilePublishBase::PublishFiles(vsFileNames, bFromuserToGroupFolder, m_bGroupMgr);
	}

private:
	bool m_bGroupMgr;
	string m_strFileExt;	//------ Folger 09/14/07 REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR
};

///------ Folger 07/02/09 SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER
#ifdef		__SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER__
class OMCPublish : public ProjectPublish
{
public:
	OMCPublish(string strFileExt, bool bGroupMgr = true, LPCSTR lpcszSubPath = NULL) : ProjectPublish(strFileExt, bGroupMgr, lpcszSubPath)
	{
	}
	/// virtual
	int PublishFiles(vector<string> &vsFileNames, bool bFromuserToGroupFolder = true, bool bGroupMgr = true)
	{
		vsFileNames.Add(MENU_CUSTOMIZATION_CONFIGURATION_FILE);
		return ProjectPublish::PublishFiles(vsFileNames, bFromuserToGroupFolder, bGroupMgr);
	}
};
#endif		/// __SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER__
///------ Folger 07/02/09 SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER

class OriginCPublish : public FilePublishBase
{
public:
	OriginCPublish(bool bGroupMgr = true)
	{
		GetSourceDestFilePath(m_strUserPath, m_strGroupPath, bGroupMgr);
		m_strUserPath += "OriginC\\";
		m_strGroupPath += "OriginC\\";
		m_bGroupMgr = bGroupMgr;
	}
	
	virtual int GetFiles(int nPath, vector<string>& vsFiles)
	{
		vector<string> vsExt = {".h", ".c", ".cpp"};
		string strPath;
		if (m_bGroupMgr)
			strPath = nPath == ORIGIN_PATH_USER ? m_strUserPath : m_strGroupPath;
		else
			strPath = nPath == ORIGIN_PATH_USER ? m_strGroupPath : m_strUserPath;
		GetFiles(strPath, vsExt, vsFiles);
		return vsFiles.GetSize();
	}
	
	virtual int PublishFiles(vector<string> &vsFileNames, bool bFromuserToGroupFolder = true, bool bGroupMgr = true)
	{
		return FilePublishBase::PublishFiles(vsFileNames, bFromuserToGroupFolder, m_bGroupMgr);
	}
	
private:
	bool m_bGroupMgr;
};
//------ End SUPPORT_MORE_FILE_TYPES

//------ Folger 09/08/07 SUPPORT_PATCH_FILE
#define STR_UPDATE_FOLDER		"Updates\\"
#define STR_UPDATE_INI_FILE		"update.ini"
#define STR_SECTION_PATCH		"patch8"
#define STR_KEY_BUILD			"build"

class PatchPublish : public FilePublishBase
{
public:
	PatchPublish()
	{
		m_strUserPath = okutil_get_origin_path(ORIGIN_PATH_SYSTEM, STR_UPDATE_FOLDER, TRUE);
		//------ CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH
		//m_strGroupPath = okutil_get_origin_path(ORIGIN_PATH_GROUP, STR_UPDATE_FOLDER, TRUE);
		m_strGroupPath = GetGroupFolderPath(STR_UPDATE_FOLDER);
		//------
	}
	
	virtual int GetFiles(int nPath, vector<string>& vsFiles)
	{
		vector<string> vsExt = {".exe"};
		string strPath = nPath == ORIGIN_PATH_USER ? m_strUserPath : m_strGroupPath;
		GetFiles(strPath, vsExt, vsFiles);
		return vsFiles.GetSize();
	}
	
	virtual int PublishFiles(vector<string> &vsFileNames, bool bFromuserToGroupFolder = true, bool bGroupMgr = true)
	{
		int nSize = vsFileNames.GetSize();
		CheckMakePath(bFromuserToGroupFolder ? m_strGroupPath : m_strUserPath);		//------ Folger 09/11/07 MAKE_PATH_BEFORE_COPY
		for (int ii=nSize-1; ii>=0; ii--)
		{
			if (bFromuserToGroupFolder)
			{
				//------ Folger 09/27/07 RESET_ATTRIBUTE_WHEN_COPY_FILE
				//if (!CopyFile(m_strUserPath + vsFileNames[ii], m_strGroupPath + vsFileNames[ii]))
				if (copyfile(m_strUserPath + vsFileNames[ii], m_strGroupPath + vsFileNames[ii], 0))
				//------ End RESET_ATTRIBUTE_WHEN_COPY_FILE
					vsFileNames.RemoveAt(ii);
			}
					
			else
			{
				//------ Folger 09/27/07 RESET_ATTRIBUTE_WHEN_COPY_FILE
				//if (!CopyFile(m_strGroupPath + vsFileNames[ii], m_strUserPath + vsFileNames[ii]))
				if (copyfile(m_strGroupPath + vsFileNames[ii], m_strUserPath + vsFileNames[ii], 0))
				//------ End RESET_ATTRIBUTE_WHEN_COPY_FILE
					vsFileNames.RemoveAt(ii);
			}
		}
		
		if (bFromuserToGroupFolder)
			checkSetUpdateINI();
		return vsFileNames.GetSize();
	}
	
	virtual int RemoveFiles(vector<string> &vsFileNames, bool bGroupFolder = true)
	{
		FilePublishBase::RemoveFiles(vsFileNames, bGroupFolder);
		if (bGroupFolder)
			checkSetUpdateINI();
		return vsFileNames.GetSize();
	}
	
private:
	
	bool checkSetUpdateINI()
	{
		vector<string> vsFiles;
		//------ CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH
		//GetFiles(ORIGIN_PATH_GROUP, vsFiles);
		GetFiles(ORIGIN_PATH_SERVER_GROUP_FOLDER, vsFiles);
		//------
		int nSize = vsFiles.GetSize();
		
		int nNewBuildTo = 0;
		for (int ii=0; ii<nSize; ii++)
		{
			int nBuildFrom, nBuildTo;
			get_patch_build_version(vsFiles[ii], &nBuildTo, &nBuildFrom);
			if (nBuildTo > nNewBuildTo)
				nNewBuildTo = nBuildTo;
		}
		//------ CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH
		//INIFile iniFile(okutil_get_origin_path(ORIGIN_PATH_GROUP) + STR_UPDATE_INI_FILE);
		INIFile iniFile(okutil_get_origin_path(ORIGIN_PATH_SERVER_GROUP_FOLDER) + STR_UPDATE_INI_FILE);
		//------
		iniFile.WriteInt(STR_SECTION_PATCH, STR_KEY_BUILD, nNewBuildTo);
		
		return true;
	}
	
};
//------ End SUPPORT_PATCH_FILE
//------ Folger 09/14/07 REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR
#define STR_DIALOG_THEME_FOLDER	"Themes\\AnalysisAndReportTable\\"

class DialogThemePublish : public FilePublishBase
{
public:
	
	DialogThemePublish()
	{
		m_strUserPath = okutil_get_origin_path(ORIGIN_PATH_USER, STR_DIALOG_THEME_FOLDER, TRUE);
		//------ CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH
		//m_strGroupPath = okutil_get_origin_path(ORIGIN_PATH_GROUP, STR_DIALOG_THEME_FOLDER, TRUE);
		m_strGroupPath = GetGroupFolderPath(STR_DIALOG_THEME_FOLDER);
		//------
	}
	
	virtual int GetFiles(int nPath, vector<string>& vsFiles)
	{
		vector<string> vsExt = {".ois"};
		string strPath;
		strPath = nPath == ORIGIN_PATH_USER ? m_strUserPath : m_strGroupPath;
		GetFiles(strPath, vsExt, vsFiles);
		
		int nSize = vsFiles.GetSize();
		for (int ii=nSize-1; ii>=0; ii--)
		{
			string strName, strTool, strScope, strCategory;
			theme_filename_to_options(vsFiles[ii], strName, strTool, strScope ,strCategory);
			//------ Folger 11/05/07 CORRECT_THEME_TYPE_COMPARE
			//if (strName.CompareNoCase("Last used.ois") == 0)
			if (is_theme_last_used(GetFileName(strName, true)))
			//------ End CORRECT_THEME_TYPE_COMPARE
				vsFiles.RemoveAt(ii);
		}
		
		return vsFiles.GetSize();
	}

};
//------ End REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR
class FileTransferBase : public FilePublishBase
{
public:
	FileTransferBase()
	{
		//------ Folger 08/31/07 USE_OKUTIL_FUNCTION_GET_ORIGIN75_USER_PATH
		//Registry reg(HKEY_CURRENT_USER);
		//string strKey = "Software\\OriginLab\\Origin 7.5\\English\\";
		//if (!reg.GetValue(strKey, "Path", m_strUserPath))
			//return;
		//------ CPY 9/1/2007 CLEAN_UP_CODE_RELATED_TO_GETTING_75_FDF_FILES
		/*
		m_strUserPath = okutil_get_origin_path(ORIGIN_PATH_USER_PREV_VER);
		//------ End USE_OKUTIL_FUNCTION_GET_ORIGIN75_USER_PATH
		m_strGroupPath = okutil_get_origin_path(ORIGIN_PATH_USER, NULL, TRUE);
		*/
		GetSourceDestFilePath(m_strUserPath, m_strGroupPath, false);
		//----- end CLEAN_UP_CODE_RELATED_TO_GETTING_75_FDF_FILES
	}
	
	//virtual int GetColNames(vector<string> &vsColNames,int nPath)
	//{
		//string strFile;
		//switch (nPath)
		//{
		//case ORIGIN_PATH_USER:
			//strFile = _L("8.0 User Files");
			//break;
		//case ORIGIN_PATH_USER75:
			//strFile = _L("7.5 User Files");
			//break;
		//default:
			//break;
		//}
		//vsColNames.Add(strFile);
		//return vsColNames.GetSize();
	//}
	//------ Folger 09/03/07 SUPPORT_MORE_FILE_TYPES
	//virtual int PublishFiles(vector<string> &vsFileNames, bool bFromuserToGroupFolder = true, bool bGroupMgr = true)
	//{
		//int nSize = vsFileNames.GetSize();
		//vector<string> vsFileFullNames(nSize);
		//for (int ii=0; ii<nSize; ii++)
		//{
			//vsFileFullNames[ii] = m_strUserPath + vsFileNames[ii];
		//}
		//
		//int nRet = CopyFiles(vsFileFullNames, bFromuserToGroupFolder, false);
		//
		//if (nRet)
		//{
			//FilePublishBase::PublishFiles(vsFileNames);
		//}
		//
		//return nRet;
	//}
	//
	//virtual int RemoveFiles(vector<string> &vsFileNames, bool bGroupFolder = true)
	//{
		//int nSize = vsFileNames.GetSize();
		//for (int ii=0; ii<nSize; ii++)
		//{
			//DeleteFile(m_strGroupPath + vsFileNames[ii]);
		//}
		//return nSize;
	//}
	
	virtual int PublishFiles(vector<string> &vsFileNames, bool bFromuserToGroupFolder = true, bool bGroupMgr = true)
	{
		return FilePublishBase::PublishFiles(vsFileNames, bFromuserToGroupFolder, false);
	}
	//------ End SUPPORT_MORE_FILE_TYPES
};

#define STR_TEMPLATE_INI		"template.ini"

class TemplateTransfer : public FileTransferBase
{
	virtual int GetFiles(int nPath, vector<string>& vsFiles)
	{
		if (nPath == ORIGIN_PATH_USER)
			tp.GetFiles(nPath, vsFiles);
		else
		{
			vector<string> vsFileExts = {".otp", ".otw", ".otm"};
			GetFiles(m_strUserPath, vsFileExts, vsFiles);
		}
		
		return vsFiles.GetSize();
	}
	
	virtual int PublishFiles(vector<string> &vsFileNames, bool bFromuserToGroupFolder = true, bool bGroupMgr = true)
	{
		int nSize = vsFileNames.GetSize();
		vector<string> vsFileFullNames(nSize);
		vector<string> vsPictures;
		
		for (int ii=0; ii<nSize; ii++)
		{
			string strCate = getTemplateSection(vsFileNames[ii]);
			if (strCate.IsEmpty())
				strCate = "Origin75";
			
			int nTemplateType = _get_template_type_from_name(vsFileNames[ii]);
			vsFileFullNames[ii] = m_strUserPath + vsFileNames[ii];
			
			_check_create_tempalte_xml(STR_TEMPLATE_XML);		//------ Folger 09/19/08 FIX_TEMPLATE_TRANSFER_FAIL_WHEN_TEMPLATE_XML_IN_UFF_IS_NOT_EXIST
			
			//------ Folger 09/29/07 NEW_DISIGN_FOR_SAVING_TEMPLATE_XML
			//okutil_add_template(STR_TEMPLATE_XML, strCate, m_strGroupPath + vsFileNames[ii], nTemplateType);
			okutil_add_template(STR_TEMPLATE_XML, strCate, vsFileNames[ii], nTemplateType);
			//------ End NEW_DISIGN_FOR_SAVING_TEMPLATE_XML
			
			string strPicture = _check_get_pictrue_name(vsFileFullNames[ii]);
			if (!strPicture.IsEmpty())
				vsPictures.Add(strPicture);
		}
		
		int nRet = CopyFiles(vsFileFullNames, bFromuserToGroupFolder, false);
		if (nRet != nSize)
		{
			for (ii=nSize-1; ii>=0; ii--)
			{
				if (vsFileFullNames[ii].IsEmpty())
					vsFileNames.RemoveAt(ii);
			}
		}
		if (vsPictures.GetSize())
			CopyFiles(vsPictures, bFromuserToGroupFolder, false);
		
		return nRet;
	}
	
	virtual int RemoveFiles(vector<string> &vsFileNames, bool bGroupFolder = true)
	{		
		tp.RemoveFiles(vsFileNames, false);
		return vsFileNames.GetSize();
	}
	
private:
	
	string getTemplateSection(string strFile)
	{
		INIFile ini(m_strUserPath + STR_TEMPLATE_INI);
		
		vector<string> vsSections;
		ini.GetSectionNames(vsSections);
		
		int nSize = vsSections.GetSize();
		for (int ii=1; ii<nSize; ii++)
		{
			vector<string> vsKeys;
			ini.GetKeyNames(vsKeys, vsSections[ii]);
			int nKeySize = vsKeys.GetSize();
			for (int jj=0; jj<nKeySize; jj++)
			{
				if (strFile.CompareNoCase(ini.ReadString(vsSections[ii], vsKeys[jj])) == 0)
					return vsSections[ii];
			}
		}		
		return "";
	}
	
private:
	TemplatePublish tp;

};

class ImpFilterTransfer : public FileTransferBase
{
public:
	
	ImpFilterTransfer()
	{
		m_strUserPath += FILTERS_FOLDER_NAME;
		m_strGroupPath += FILTERS_FOLDER_NAME;
	}
	
	virtual int GetFiles(int nPath, vector<string>& vsFiles)
	{ 
		vector<string> vsExt = {IMPORT_FILTER_EXTENSION};
		GetFiles(nPath == ORIGIN_PATH_USER ? m_strGroupPath : m_strUserPath, vsExt, vsFiles);
		return vsFiles.GetSize();
	}
};

class FDFTransfer : public FileTransferBase
{
public:
	
	FDFTransfer()
	{
		//------ Folger 09/11/07 FIX_BUGS_IN_FDF_FILE_COMPARE
		//m_strUserPath += STR_FDF_FILE_FOLDER;
		//m_strGroupPath += STR_FDF_FILE_FOLDER;
		m_strUserPath += STR_FDF_FILE_FOLDER_BACKSLASH;
		m_strGroupPath += STR_FDF_FILE_FOLDER_BACKSLASH;
		//------ End FIX_BUGS_IN_FDF_FILE_COMPARE
	}
	//------ Folger 08/30/07 MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
	virtual int GetFiles(int nPath, vector<string>& vsFiles)
	{ 
		bool bGroupFolder = nPath == USER_FOLDER;
		vector<string> vsFullFileNames;
		m_gfo.GetFilesList(vsFiles, vsFullFileNames, bGroupFolder, false);
		//------ Folger 09/11/07 FIX_BUGS_IN_FDF_FILE_COMPARE
		//return vsFiles.GetSize();		
		return _append_file_ext(vsFiles, STR_FDF_FILE_EXT);
		//------ End FIX_BUGS_IN_FDF_FILE_COMPARE	
	}
	virtual int PublishFiles(vector<string> &vsFileNames, bool bFromuserToGroupFolder = true, bool bGroupMgr = true)
	{ 
		int nNum = 0;
		for (int ii = 0; ii < vsFileNames.GetSize(); ii++)
		{
			//------ Folger 09/11/07 FIX_BUGS_IN_FDF_FILE_COMPARE
			//if ( m_gfo.AddFile(vsFileNames[ii], bFromuserToGroupFolder, false) )
			string strFile = vsFileNames[ii];
			strFile.Replace(STR_FDF_FILE_EXT, "");
			if ( m_gfo.AddFile(strFile, bFromuserToGroupFolder, false) )
			//------ End FIX_BUGS_IN_FDF_FILE_COMPARE
				nNum++;
			else
				vsFileNames.RemoveAt(ii--);
		}
		
		return nNum;
	}
	
	virtual int RemoveFiles(vector<string> &vsFileNames, bool bGroupFolder = true)
	{
		int nNum = 0;
		for (int ii = 0; ii < vsFileNames.GetSize(); ii++)
		{
			//------ Folger 09/11/07 FIX_BUGS_IN_FDF_FILE_COMPARE
			//if ( m_gfo.RemoveFile(vsFileNames[ii], bGroupFolder, false) )
			string strFile = vsFileNames[ii];
			strFile.Replace(STR_FDF_FILE_EXT, "");
			if ( m_gfo.RemoveFile(strFile, bGroupFolder, false) )
			//------ End FIX_BUGS_IN_FDF_FILE_COMPARE
				nNum++;
			else
				vsFileNames.RemoveAt(ii--);
		}
		
		return nNum;
	}
	
private:
	GroupFunctionOrganizer	m_gfo;
	//------ End MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
};

class OGSTransfer : public FileTransferBase
{
	virtual int GetFiles(int nPath, vector<string>& vsFiles)
	{ 
		vector<string> vsExt = {".ogs"};
		GetFiles(nPath == ORIGIN_PATH_USER ? m_strGroupPath : m_strUserPath, vsExt, vsFiles);
		return vsFiles.GetSize();
	}
};

class ThemeTransfer : public FileTransferBase
{
public:
	
	ThemeTransfer()
	{
		m_strUserPath += STR_THEME_FILE_FOLDER;
		m_strGroupPath += STR_THEME_FILE_FOLDER + "Graph\\";
	}
	
	virtual int GetFiles(int nPath, vector<string>& vsFiles)
	{ 
		vector<string> vsExt = {".oth"};
		GetFiles(nPath == ORIGIN_PATH_USER ? m_strGroupPath : m_strUserPath, vsExt, vsFiles);
		return vsFiles.GetSize();
	}
	
	virtual int PublishFiles(vector<string> &vsFileNames, bool bFromuserToGroupFolder = true, bool bGroupMgr = true)
	{
		int nSize = vsFileNames.GetSize();
		CheckMakePath(m_strGroupPath);		//------ Folger 09/11/07 MAKE_PATH_BEFORE_COPY
		for (int ii=nSize-1; ii>=0; ii--)
		{
			//------ Folger 09/27/07 RESET_ATTRIBUTE_WHEN_COPY_FILE
			//if (!CopyFile(m_strUserPath + vsFileNames[ii], m_strGroupPath + vsFileNames[ii]))
			if (copyfile(m_strUserPath + vsFileNames[ii], m_strGroupPath + vsFileNames[ii], 0))
			//------ End RESET_ATTRIBUTE_WHEN_COPY_FILE
				vsFileNames.RemoveAt(ii);
		}
				
		return vsFileNames.GetSize();
	}
};
//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
enum
{
	FILE_TYPE_OGW,
	FILE_TYPE_DIALOG_THEME,
	FILE_TYPE_FDF,
	FILE_TYPE_IMPORT_FILTER,
	FILE_TYPE_OGS,
	FILE_TYPE_DATABASE,		//------ Folger 09/18/08 QA80-12217 SUPPORT_PUBLISHING_DATABASE_FILES
	FILE_TYPE_ORIGINC,
	//------ Folger 09/28/07 SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION
#ifdef SUPPORT_PACKAGE_FILES
	FILE_TYPE_PACKAGE,
#endif
	//------ End SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION
	FILE_TYPE_TEMPLATE,
	FILE_TYPE_PATCH,
	FILE_TYPE_PROJECT,
	FILE_TYPE_THEME,
	FILE_TYPE_XF,
	//------ Folger 09/18/08 QA80-12217 SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER
	#ifdef		__SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER__
	FILE_TYPE_OMC,
	#endif		/// SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER
	//------ End SUPPORT_PUBLISHING_DATABASE_FILES
	FILE_TYPE_DEFAULT_SETTINGS,		//------ Folger 03/20/08 QA80-11192 SUPPORT_DEFAULT_SETTINGS_FILE
	FILE_TYPE_OTHER_FILE,
	FILE_TYPE_ALL_FILE,
};

//------ Folger 09/14/07 REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR
#define STR_PROJECT_FILE_EXT			".opj"
#define STR_ANALYSIS_TEMPLATE_EXT		".ogw"
#define STR_OTHER_FILE_EXT				".doc|.pdf"
//------ Folger 09/28/07 SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION
#ifdef SUPPORT_PACKAGE_FILES
#define STR_PACKAGE_80_EXT				".opx"
#define STR_PACKAGE_75_EXT				".opk"
#define STR_PACKAGE_SUB_FOLDER			"Auto Install\\" /// EJP 2007-10-02 v8.0714 QA70-10469 MORE_WORK_FOR_OPX_AND_GROUP_FOLDER
#endif
//------ End REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR

//------ Folger 09/18/08 QA80-12217 SUPPORT_PUBLISHING_DATABASE_FILES
#define STR_DATABASE_FILE_EXT			".ODQ|.ODS"
//------

///------ Folger 07/02/09 SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER
#ifdef		__SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER__
#define STR_OMC_FILE_EXT				"." MENU_CUSTOMIZATION_FILE_EXT
#endif		/// __SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER__
///------ End SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER

class AllFilePublish : public FilePublishBase
{
public:	
	
	AllFilePublish(bool bGroupMgr = true)
	{
		m_bGroupMgr = bGroupMgr;
		m_pThemeFilePublish = m_pXFFilePublish = NULL;
		vector<int> vnAllFileType = {
			FILE_TYPE_OGW,
			FILE_TYPE_DIALOG_THEME,
			FILE_TYPE_FDF,
			FILE_TYPE_IMPORT_FILTER,
			FILE_TYPE_OGS,
			FILE_TYPE_DATABASE,		//------ Folger 09/18/08 QA80-12217 SUPPORT_PUBLISHING_DATABASE_FILES
			FILE_TYPE_ORIGINC,
			//------ Folger 09/28/07 SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION
#ifdef SUPPORT_PACKAGE_FILES
			FILE_TYPE_PACKAGE,
#endif
			//------ End SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION
			FILE_TYPE_TEMPLATE,
			FILE_TYPE_PATCH,
			FILE_TYPE_PROJECT,
			FILE_TYPE_THEME,
			FILE_TYPE_XF,
			///------ Folger 07/02/09 SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER
			#ifdef		__SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER__
			FILE_TYPE_OMC,
			#endif		/// __SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER__
			///------ End SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER
			FILE_TYPE_DEFAULT_SETTINGS,		//------ Folger 03/20/08 QA80-11192 SUPPORT_DEFAULT_SETTINGS_FILE
			FILE_TYPE_OTHER_FILE
		};
		m_vnValidFileType = m_vnAllFileType = vnAllFileType;
		
		vector<string> vsAllFileTypeExt = {
			"OGW",
			"OIS",
			"FDF",
			"OIF",
			"OGS",
			"ODQ|ODS",		//------ Folger 09/18/08 QA80-12217 SUPPORT_PUBLISHING_DATABASE_FILES
			"H|C|CPP",
			//------ Folger 09/28/07 SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION
#ifdef SUPPORT_PACKAGE_FILES
			"OPX|OPK",
#endif
			//------ End SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION
			"OTP|OTW|OTM",
			"EXE",
			"OPJ",
			"OTH",
			"OXF",
			///------ Folger 07/02/09 SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER
			#ifdef		__SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER__
			MENU_CUSTOMIZATION_FILE_EXT,
			#endif		/// __SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER__
			///------ End SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER
			"XML",		//------ Folger 04/03/08 FIX_DEFAULT_XML_PUBLISH_IN_ALL_FILES
			"DOC|PDF"
		};
		m_vsAllFileTypeExt = vsAllFileTypeExt;
		
		if (!bGroupMgr)
		{
			vector<int> vnRemove = {FILE_TYPE_DIALOG_THEME, FILE_TYPE_PATCH, FILE_TYPE_XF, FILE_TYPE_DEFAULT_SETTINGS};
			for (int ii=0; ii<vnRemove.GetSize(); ii++)
			{
				vector<uint> vnIndecies;
				if (m_vnValidFileType.Find(vnIndecies, vnRemove[ii]) > 0)
					m_vnValidFileType.RemoveAt(vnIndecies[0]);
			}
		}
		else if (!okutil_is_group_files_update_feature_permitted())
		{
			m_vnValidFileType.SetSize(0);
			m_vnValidFileType.Add(FILE_TYPE_PATCH);
		}
		
	}
	
	~AllFilePublish()
	{
		delete m_pThemeFilePublish;
		delete m_pXFFilePublish;
	}
	
	virtual int GetColNames(vector<string> &vsColNames,int nPath)
	{
		FilePublishBase::GetColNames(vsColNames, nPath);
		if (m_bGroupMgr)
			vsColNames.Add(_L("Category"));
		vsColNames.Add(_L("File Type"));
		return vsColNames.GetSize();
	}
	
	virtual int GetRowInfo(string strKey, vector<string> &vsRowInfo, int nPath)
	{
		vsRowInfo.Add(GetFileName(strKey));
		if (m_bGroupMgr)
			vsRowInfo.Add(GetFilePath(strKey));
		string strExt;
		separate_file_name_ext(vsRowInfo[0], NULL, &strExt);
		vsRowInfo.Add(getEnumIndexFromFileExt(strExt));
		
		return vsRowInfo.GetSize();
	}
	
	virtual int GetFiles(int nPath, vector<string>& vsFiles)
	{
		for (int ii=0; ii<m_vnValidFileType.GetSize(); ii++)
		{
			FilePublishBase *pFilePublish = NULL;
			if (getFilePublishDerivation(m_vnValidFileType[ii], pFilePublish))
			{
				vector<string> vsSubFiles;
				pFilePublish->GetFiles(nPath, vsSubFiles);
				vsFiles.Append(vsSubFiles);
				if (m_vnValidFileType[ii] == FILE_TYPE_THEME)
					m_pThemeFilePublish = pFilePublish;
				else if (m_vnValidFileType[ii] == FILE_TYPE_XF)
					m_pXFFilePublish = pFilePublish;
				else
					delete pFilePublish;
			}
		}
		return true;
	}
	
	virtual int PublishFiles(vector<string> &vsFileNames, bool bFromuserToGroupFolder = true, bool bGroupMgr = true)
	{
		return fileOperation(vsFileNames, bFromuserToGroupFolder, bGroupMgr, true);
	}
	
	virtual int RemoveFiles(vector<string> &vsFileNames, bool bGroupFolder = true)
	{
		return fileOperation(vsFileNames, bGroupFolder, true, false);
	}
	
	virtual bool GetFileFullPath(string &strFile1, string &strFile2)
	{
		string strExt;
		separate_file_name_ext(strFile1, NULL, &strExt);
		FilePublishBase *pFilePublish = NULL;
		if (getFilePublishDerivation(getEnumIndexFromFileExt(strExt), pFilePublish))
		{
			strFile1 = pFilePublish->GetUserPath() + strFile1;
			strFile2 = pFilePublish->GetGroupPath() + strFile2;
		}
		return true;
	}

private:
	
	int getEnumIndexFromFileExt(string strExt)
	{
		for (int ii=0; ii<m_vsAllFileTypeExt.GetSize(); ii++)
		{
			vector<string> vsExts;
			m_vsAllFileTypeExt[ii].GetTokens(vsExts, '|');
			int nIndex;
			if ((nIndex = vsExts.Find(strExt)) >= 0)
				return ii;
		}
		return -1;
	}
	
	bool getFilePublishDerivation(int nIndex, FilePublishBase* &pFilePublish)
	{
		switch (nIndex)
		{
		case FILE_TYPE_TEMPLATE:
			if (m_bGroupMgr)
				pFilePublish = new TemplatePublish();
			else
				pFilePublish = new TemplateTransfer();
			break;
		case FILE_TYPE_IMPORT_FILTER:
			if (m_bGroupMgr)
				pFilePublish = new ImpFilterPublish();
			else
				pFilePublish = new ImpFilterTransfer();
			break;
		case FILE_TYPE_FDF:
			if (m_bGroupMgr)
				pFilePublish = new FDFPublish();
			else
				pFilePublish = new FDFTransfer();
			break;
		case FILE_TYPE_OGS:
			if (m_bGroupMgr)
				pFilePublish = new OGSPublish();
			else
				pFilePublish = new OGSTransfer();
			break;
		case FILE_TYPE_THEME:
			if (m_bGroupMgr)
			{
				if (m_pThemeFilePublish)
					pFilePublish = m_pThemeFilePublish;
				else
					pFilePublish = new ThemePublish();
			}
			else
				pFilePublish = new ThemeTransfer();
			break;
		case FILE_TYPE_PROJECT:
			pFilePublish = new ProjectPublish(STR_PROJECT_FILE_EXT, m_bGroupMgr);
			break;
		case FILE_TYPE_ORIGINC:
			pFilePublish = new OriginCPublish(m_bGroupMgr);
			break;
			
		//------ Folger 09/18/08 QA80-12217 SUPPORT_PUBLISHING_DATABASE_FILES
		case FILE_TYPE_DATABASE:
			pFilePublish = new ProjectPublish(STR_DATABASE_FILE_EXT, m_bGroupMgr);
			break;
		//------
		
		case FILE_TYPE_XF:
			if (m_pXFFilePublish)
				pFilePublish = m_pXFFilePublish;
			else
				pFilePublish = new XFPublish();
			break;

		///------ Folger 07/02/09 SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER
		#ifdef		__SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER__
		case FILE_TYPE_OMC:
			pFilePublish = new OMCPublish(STR_OMC_FILE_EXT, m_bGroupMgr);
			break;
		#endif		/// __SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER__
		///------ End SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER
			
		//------ Folger 03/20/08 QA80-11192 SUPPORT_DEFAULT_SETTINGS_FILE
		case FILE_TYPE_DEFAULT_SETTINGS:
			pFilePublish = new DefaultSettingsPublish();
			break;
		//------
			
		case FILE_TYPE_PATCH:
			pFilePublish = new PatchPublish();
			break;
		case FILE_TYPE_OGW:
			pFilePublish = new ProjectPublish(STR_ANALYSIS_TEMPLATE_EXT, m_bGroupMgr);
			break;
		case FILE_TYPE_DIALOG_THEME:
			pFilePublish = new DialogThemePublish();
			break;
		case FILE_TYPE_OTHER_FILE:
			pFilePublish = new ProjectPublish(STR_OTHER_FILE_EXT, m_bGroupMgr);
			break;
		//------ Folger 09/28/07 SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION
#ifdef SUPPORT_PACKAGE_FILES
		case FILE_TYPE_PACKAGE:
			/// EJP 2007-10-02 v8.0714 QA70-10469 MORE_WORK_FOR_OPX_AND_GROUP_FOLDER
			///	if (m_bGroupMgr)
			///		pFilePublish = new ProjectPublish(STR_PACKAGE_80_EXT, m_bGroupMgr);
			///	else
			///		pFilePublish = new ProjectPublish(STR_PACKAGE_75_EXT, m_bGroupMgr);
			pFilePublish = new ProjectPublish((m_bGroupMgr ? STR_PACKAGE_80_EXT : STR_PACKAGE_75_EXT),	m_bGroupMgr, m_bGroupMgr ? STR_PACKAGE_SUB_FOLDER : "");
			/// end MORE_WORK_FOR_OPX_AND_GROUP_FOLDER
			break;
#endif
		//------ End SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION
		default:
			break;
		}
		return pFilePublish != NULL;
	}
	
	int fileOperation(vector<string> &vsFileNames, bool bFromuserToGroupFolder = true, bool bGroupMgr = true, bool bPublish = true)
	{
		int nSize = vsFileNames.GetSize();
		for (int ii=nSize-1; ii>=0; ii--)
		{
			string strExt;
			separate_file_name_ext(vsFileNames[ii], NULL, &strExt);
			FilePublishBase *pFilePublish = NULL;
			if (getFilePublishDerivation(getEnumIndexFromFileExt(strExt), pFilePublish))
			{
				vector<string> vsTmpFile;
				vsTmpFile.Add(vsFileNames[ii]);
				if (bPublish)
				{
					if (pFilePublish->PublishFiles(vsTmpFile, bFromuserToGroupFolder, bGroupMgr) == 0)
						vsFileNames.RemoveAt(ii);
				}
				else
				{
					if (pFilePublish->RemoveFiles(vsTmpFile, bFromuserToGroupFolder) == 0)
						vsFileNames.RemoveAt(ii);
				}
			}
		}
		return vsFileNames.GetSize();
	}
	
private:
	
	FilePublishBase		*m_pThemeFilePublish;
	FilePublishBase		*m_pXFFilePublish;
	vector<int>			m_vnAllFileType;
	vector<int>			m_vnValidFileType;
	vector<string>		m_vsAllFileTypeExt;
	bool				m_bGroupMgr;
	
};
//------ End SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION

///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
#endif // _OLD_GROUP_FOLDER_MANAGER_AND_TRANSFER_USER_FILES_
///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL

static int _get_template_type_from_name(LPCSTR lpcszFileName)
{
	string strName, strExt;
	separate_file_name_ext(lpcszFileName, &strName, &strExt);
	if(strExt.Left(1) == ".")
		strExt = strExt.GetToken(1, '.');
	if(!strExt.CompareNoCase("otp"))
		return EXIST_GRAPH;
	if(!strExt.CompareNoCase("otw"))
		return EXIST_WKS;
	if(!strExt.CompareNoCase("otm"))
		return EXIST_MATRIX;
	return EXIST_NONE;
}

static string _check_get_pictrue_name(LPCSTR lpcszFileFullName)
{
	char szFileName[100];
	char szExt[20];
	string strRet;
	
	lstrcat(szFileName, lpcszFileFullName);
	check_add_file_ext(szFileName, NULL, szExt);
	string strExt = szExt;
	
	if (strExt.CompareNoCase("OTP") == 0)
	{
		string strPicture = get_graph_template_preview_file(lpcszFileFullName);
		lstrcat(szFileName, strPicture);
		check_add_file_ext(szFileName, NULL, szExt);
		string strNameOnly = GetFileName(lpcszFileFullName, true);
		string strPath = GetFilePath(lpcszFileFullName);
		strRet = strPath + strNameOnly + '.' + szExt;
	}
	
	return strRet;
}
//------ End SUPPORT_TRANSFER_FILES_FROM_75_TO_80
//------ Folger 08/29/07 SAVE_PARTITIAL_GROUP_PATH_FOR_PUBLISH
static TreeNode _tree_add_cate_node(TreeNode& trParent, string& strCateName)
{
	string strCateNode = tree_get_enum_node_name(trParent, STR_CATEGORY_NODE);//STR_BRANCH_NODE);	///Jasmine 02/05/06 QA70-8498 v8.0364 TEMPLATE_INFO_INTERNAL_ACCESS_NAME_CHANGE
	TreeNode trCate = trParent.AddNode(strCateNode, TRGP_BRANCH);
	if(strCateName.IsEmpty())
		strCateName = tree_get_enum_attribute_value(trParent, STR_LABEL_ATTRIB, STR_NEW_CATEGORY_PREFIX);
	bool flag = trCate.SetAttribute(STR_LABEL_ATTRIB, strCateName);
	return trCate;
}
static TreeNode _tree_add_temp_node(TreeNode& trParent, string strTempName, string strFileName)
{
	string strTempNode = tree_get_enum_node_name(trParent, STR_TEMPLATE_NODE);
	TreeNode trTemplate = trParent.AddNode(strTempNode, ONODETYPE_TREE_NODE);
	bool flag = trTemplate.SetAttribute(STR_LABEL_ATTRIB, strTempName);
	flag = trTemplate.SetAttribute(STR_FILENAME_ATTRIB, strFileName);
	return trTemplate;
}
//------ End SAVE_PARTITIAL_GROUP_PATH_FOR_PUBLISH

//------ Folger 09/11/07 FIX_BUGS_IN_FDF_FILE_COMPARE
static int _append_file_ext(vector<string> &vsFiles, string strExt)
{
	int nSize = vsFiles.GetSize();
	for (int ii=0; ii<nSize; ii++)
	{
		vsFiles[ii] += strExt;
	}
	return nSize;
}
//------ End FIX_BUGS_IN_FDF_FILE_COMPARE

#endif//_FILE_PUBLISH_H_
